#include "main.h"
#include "Player.h"
#include "PlayerList.h"

//game module managers
GUIManager *guiManager;
NetworkManager *networkManager;
SoundManager *soundManager;
extern SoundObjectList *soundList;

char serveraddrport[20];

extern RenderEngine *renderEngine;
extern 	PlayerList *playerList;
extern 	XPModelList *projectileList;
extern bool matrixmode;
extern int musicChannel;

unsigned char packet[MAXPACKETLEN];



int main(int argc, char **argv)
{

	if (argc < 2)
	{
		printf("Usage: game serverIP:port [GLUT arguments]\n");
		exit(0);
	}

	//read server address and port
	//store it for later
	strcpy(serveraddrport, argv[1]);

	//initialize game engine state
	soundManager = new SoundManager;
	soundManager->initializeSound();
	networkManager = new NetworkManager;
	
	//prepare to give up control
	guiManager = new GUIManager(argc, argv);
	glutMainLoop();

    return 0;
}



void endGame()
{
	soundManager->close();
	delete soundManager;
	delete networkManager;
	delete guiManager;
}

void setGameState(State newState)
{
	guiManager->setState(newState);
}

inline void useItem(char item)
{
	networkManager->sendCommand(item);
}

void movePosition(float move, float strafe, double intervaltime)
{
	
}

void asyncRecvUpdate()
{

	int cursor = 0;
	unsigned char command, task;
	static bool firsttime = true;
	int packetlen;
	Player *player;


	// the server limits the number of updates. however, recvUpdate should not block since it is
	//called in a critical part of the code, i. e. display
	if (networkManager->asyncRecvCommand(&command) <= 0)
		return;
	//networkManager->recvCommand(&command);
	//printf("Command is %d\n",command);
	switch(command)
	{
	case BYE:
		networkManager->shutDown();
		//satyam
		//set game manager state to main menu
		break;
	
	case DELETE_PLAYER:
		networkManager->recvCommand(packet);
		playerList->removePlayer(packet[0]);
		//packet[0] has the player token # to be deleted. DO IT
		//DONT read anything but packet[0]. you'll get junk

		break;



	case PROJECTILECREATED:
			
			{
				networkManager->recvPacket(packet, PROJECTILECREATEDLENGTH);
				unsigned char id,owner,mType;
				readByte(packet,cursor,owner);
				readByte(packet,cursor,id);
				readByte(packet,cursor,mType);

				XPModel *projectile=new XPModel(mType);
				projectile->setOwner(owner);
				projectile->setID(id);
				
				float vec[3];
				//Position
				readFloat(packet,cursor,vec[0]);
				readFloat(packet,cursor,vec[1]);
				readFloat(packet,cursor,vec[2]);
				
				projectile->setPosition(vec3(vec[0],vec[1],vec[2]));

				//Sound (needs to be after position)
				vec3 myPos = viewer->getPosition();
				vec3 myRot = viewer->getOrientation();
				if ( mType == 8 ){										
					soundManager->playDirectionalSound(soundList->getSound(5),(vec[0]-myPos[0]),(vec[1]-myPos[1]),myRot[2]);
				}
				else if ( mType == 9 ){
					soundManager->playDirectionalSound(soundList->getSound(3),(vec[0]-myPos[0]),(vec[1]-myPos[1]),myRot[2]);
				}
				else if ( mType == 10 ){
					soundManager->playDirectionalSound(soundList->getSound(6),(vec[0]-myPos[0]),(vec[1]-myPos[1]),myRot[2]);
				}
				
				printf("type %d\n", mType);
				printf("pos %f %f %f\n", vec[0],vec[1],vec[2]);

				//Orientation
				
				readFloat(packet,cursor,vec[0]);
				readFloat(packet,cursor,vec[1]);
				readFloat(packet,cursor,vec[2]);
				
				projectile->setOrientation(vec3(vec[0],vec[1],vec[2]));
				printf("ori %f %f %f\n", vec[0],vec[1],vec[2]);

				//Velocity

				readFloat(packet,cursor,vec[0]);
				readFloat(packet,cursor,vec[1]);
				readFloat(packet,cursor,vec[2]);

				projectile->setVelocity(vec3(vec[0],vec[1],vec[2]));

				printf("vel %f %f %f\n", vec[0],vec[1],vec[2]);

				//Acceleration

				readFloat(packet,cursor,vec[0]);
				readFloat(packet,cursor,vec[1]);
				readFloat(packet,cursor,vec[2]);

				projectile->setAcceleration(vec3(vec[0],vec[1],vec[2]));
				projectileList->addModel(projectile);
				printf("A projectile was created\n");
				
			}
			break;

		case REMOVEPROJECTILE:
			{
				networkManager->recvPacket(packet, REMOVEPROJECTILELENGTH);
				unsigned char id,owner;
				readByte(packet,cursor,owner);
				readByte(packet,cursor,id);
				XPModel *projectile=projectileList->removeModel(owner,id);
				if(projectile!=NULL){
					delete projectile;
					printf("Removing projectile\n");
				}
				

			}
			
			break;

		case PROJECTILEUPDATE:
			{	
				networkManager->recvPacket(packet, PROJECTILEUPDATELENGTH);
				unsigned char id,owner,mType;
				readByte(packet,cursor,owner);
				readByte(packet,cursor,id);
				readByte(packet,cursor,mType);

				XPModel *projectile=projectileList->getModel(owner,id);
				if(projectile==NULL){
					break;
				}
				projectile->setOwner(owner);
				projectile->setID(id);
				projectile->setModelTypeIndex(mType);
				
				float vec[3];
				//Position
				readFloat(packet,cursor,vec[0]);
				readFloat(packet,cursor,vec[1]);
				readFloat(packet,cursor,vec[2]);
				
				projectile->setPosition(vec3(vec[0],vec[1],vec[2]));
				//Orientation
				
				readFloat(packet,cursor,vec[0]);
				readFloat(packet,cursor,vec[1]);
				readFloat(packet,cursor,vec[2]);
				
				projectile->setOrientation(vec3(vec[0],vec[1],vec[2]));

				//Velocity

				readFloat(packet,cursor,vec[0]);
				readFloat(packet,cursor,vec[1]);
				readFloat(packet,cursor,vec[2]);

				projectile->setVelocity(vec3(vec[0],vec[1],vec[2]));

				//Acceleration

				readFloat(packet,cursor,vec[0]);
				readFloat(packet,cursor,vec[1]);
				readFloat(packet,cursor,vec[2]);

				projectile->setAcceleration(vec3(vec[0],vec[1],vec[2]));
				printf("Updating projectile\n");

			}

			break;

	case OBJECTPICKED:
		{
			unsigned char playerID,id;
			networkManager->recvPacket(packet, 2);
			readByte(packet,cursor,playerID);
			readByte(packet,cursor,id);
			XPModel *model=xpModelList->getModel(id);
			if(model!=NULL){
				if(playerID==viewer->getPlayerID()){
					//Add this to viewers inventory
					int iType = model->getModelTypeIndex();

					soundManager->playDirectionalSound(soundList->getSound(15),5,0,0);

					switch (iType){
					case 5:
						viewer->weapons[0].currentAmmo += viewer->weapons[0].clipCount;
						if (viewer->weapons[0].currentAmmo > viewer->weapons[0].maxAmmo) viewer->weapons[0].currentAmmo = viewer->weapons[0].maxAmmo;
						break;
					case 6:
						viewer->weapons[1].currentAmmo += viewer->weapons[1].clipCount;
						if (viewer->weapons[1].currentAmmo > viewer->weapons[1].maxAmmo) viewer->weapons[1].currentAmmo = viewer->weapons[1].maxAmmo;
						break;
					case 7:
						viewer->weapons[2].currentAmmo += viewer->weapons[2].clipCount;
						if (viewer->weapons[2].currentAmmo > viewer->weapons[2].maxAmmo) viewer->weapons[2].currentAmmo = viewer->weapons[2].maxAmmo;
						break;
					case 11:
						viewer->weapons[0].available = true;
						break;
					case 12:
						viewer->weapons[1].available = true;
						break;
					case 13:
						viewer->weapons[2].available = true;
						break;
					case 14:
						viewer->haveGlasses = true;
						break;
					case 15:
						viewer->haveMatrix = true;
						break;
					case 16:						
						break;
					}
					
					 
				}			
				model->setActive(false);
			}
		}
		break;
	case OBJECTSPAWNED:
		{
			unsigned char count;
			XPModel *model;
			networkManager->recvCommand(&count);
			networkManager->recvPacket(packet,count);
			for(int i=0;i<count;i++){
				model=xpModelList->getModel(i);
				if(model!=NULL){
					/*
					if(model->isActive()){
						model->setActive(false);
					}
					else{

						model->setActive(true);
					}
					*/
					model->setActive(true);
				}
			}
			


		}
		break;


	case DAMAGE:
		networkManager->recvPacket(packet, 2);
		printf ("damage: %d %d\n",packet[0],packet[1]);
		printf ("%d\n",viewer->getPlayerID());
		if(viewer->getPlayerID()==packet[0]){
			viewer->changeHealth((-1)*packet[1]);
		}
		break;
	case STARTMATRIX:				
		networkManager->recvPacket(packet, 1);
		matrixmode = true;
		viewer->matrixOwner = packet[0];
		printf ("starting matrix mode\n");
		musicChannel = soundManager->playSoundOnChannel(soundList->getSound(1),musicChannel);
		soundManager->setChannelProperties(musicChannel, 1, 0, 1);
		break;
	case ENDMATRIX:
		networkManager->recvPacket(packet, 1);
		matrixmode = false;
		printf ("ending matrix mode\n");
		musicChannel = soundManager->playSoundOnChannel(soundList->getSound(0),musicChannel);
		soundManager->setChannelProperties(musicChannel, .8, 0, 1);
		break;		
	case GAMEUPDATE:
		networkManager->recvPacket(packet, 2);
		readShort(packet, cursor, packetlen);
		packetlen -= 3;
		networkManager->recvPacket(packet, packetlen);
		cursor = 0;
		while(cursor<packetlen){
			//start processing the updates
			readByte(packet, cursor, task);
			switch(task)
			{
			case LIGHTON:
				renderEngine->setLight(NORMAL);
				break;
			case LIGHTOFF:
				//satyam
				//check for IR glasses
				renderEngine->setLight(NOLIGHTS);
				break;
			case FOGON:
				{
					float fogcolor[3], density;
					readFloat(packet, cursor, fogcolor[0]);
					readFloat(packet, cursor, fogcolor[1]);
					readFloat(packet, cursor, fogcolor[2]);
					readFloat(packet, cursor, density);
					renderEngine->setFog(true, fogcolor, density);
				}
				break;
			case FOGOFF:
				renderEngine->setFog(false, NULL, 0);
				break;
				
	//put other commands here

			case PLAYERHASCHANGED:
				{
					unsigned char playerID;
				
					readByte(packet,cursor,playerID);
					float vec[3];
					player=playerList->getPlayer(playerID);
					//printf("Player changed %d \n",playerID);
					//DOnt update ur position from server
					if(player!=viewer || firsttime){
						firsttime = false;
						if(player==NULL){
							player=new Player(playerID);
							playerList->addPlayer(player);
						}

						unsigned char charTemp;
						readByte(packet,cursor,charTemp);
						player->setMotionState((MotionState)charTemp);
						
						//ModelType
						
						readByte(packet,cursor,charTemp);
						
						if(player->getModelTypeIndex()!=charTemp){
							player->setModelTypeIndex(charTemp);
						}
						
						//Position
						readFloat(packet,cursor,vec[0]);
						readFloat(packet,cursor,vec[1]);
						readFloat(packet,cursor,vec[2]);
						
						player->setPosition(vec3(vec[0],vec[1],vec[2]));
						//Orientation
						
						readFloat(packet,cursor,vec[0]);
						readFloat(packet,cursor,vec[1]);
						readFloat(packet,cursor,vec[2]);
						
						player->setOrientation(vec3(vec[0],vec[1],vec[2]));

					

						//Animation
						readByte(packet,cursor,charTemp);
						player->setAction(charTemp);

						readByte(packet,cursor,charTemp);
						player->setPreviousAction(charTemp);

						float aTime;
						readFloat(packet,cursor,aTime);
						player->setAnimationTime(aTime);

						//printf("Player %d animTime %f\n",player->getPlayerID(),aTime);
					}
					else
					{
						cursor += PLAYERHASCHANGEDLENGTH;
					}

				}
				break;
			default:
				break;
			}
		}
		break;
	default:
		break;
	}
}
