#ifndef _XPMODELH_
#define _XPMODELH_

#include "Movable.h"
#define MAXSUBPARTS 20
#include "XPSubPart.h"
class XPModel : public Movable  
{
protected:
	//One level hierarchy,make this more general?
	XPSubPart subParts[MAXSUBPARTS];
	int numberOfSubParts;
	int modelTypeIndex;
	int id;
	bool active;
	unsigned char owner;

	//For animation
	unsigned char action;
	unsigned char previousAction;
	float animationTime;
public:
	
	
	
	XPModel();
	XPModel(int index);
	virtual ~XPModel();
	void moveAsOriented(float increment);
	void moveInDirection(vec3 vector);
	void setID(int id);
	int getID();
	
	
	int getNumberOfSubParts();
	XPSubPart *getSubPart(int index);
	int getModelTypeIndex();
	void setActive(bool state);
	bool isActive();
	void setModelTypeIndex(int mdType);
	void setOwner(unsigned char own);
	unsigned char getOwner();

	//For animation
	unsigned char getAction();
	unsigned char getPreviousAction();
	float getAnimationTime();


	void setAction(unsigned char act);
	void setPreviousAction(unsigned char act);
	void setAnimationTime(float aTime);
};
#endif