#include "XPModel.h"
#include "RenderEngine.h"
#include "ModelTypeList.h"
#include "ModelType.h"
#include "XPSubPart.h"
#include "Movable.h"

extern RenderEngine *renderEngine;

XPModel::XPModel():Movable(){
	numberOfSubParts=0;

	modelTypeIndex=-1;
	active=false;
	id=-1;

	action=0;
	previousAction=0;
	animationTime=0;
}

XPModel::XPModel(int index):Movable(){
	if (index==-1){
		numberOfSubParts=0;
		
		modelTypeIndex=-1;
	}
	else{
		setModelTypeIndex(index);
		

	}
	active=false;
	id=-1;
	setVelocity(vec3(0,0,0));
	action=0;
	previousAction=0;
	animationTime=0;

}

int XPModel::getNumberOfSubParts(){
	return numberOfSubParts;
}

XPSubPart * XPModel::getSubPart(int index){
	if(index<numberOfSubParts){
		return &subParts[index];
	}
	else{
		return NULL;
	}
}

int XPModel::getModelTypeIndex(){
	return modelTypeIndex;
}

XPModel::~XPModel(){
	
}

void XPModel::moveAsOriented(float increment){
	Movable::moveAsOriented(increment);
}


void XPModel::moveInDirection(vec3 direction){
	Movable::moveInDirection(direction);
}

void XPModel::setID(int ide){
	id=ide;
}

int XPModel::getID(){
	return id;
}
void XPModel::setActive(bool state){
	active=state;
}
bool XPModel::isActive(){
	return active;
}

void XPModel::setModelTypeIndex(int index){
	modelTypeIndex=index;
		ModelType *mType=renderEngine->getModelTypeList()->getModelType(modelTypeIndex);
		numberOfSubParts=mType->getNumParts();
		
		for(int i=0;i<numberOfSubParts;i++){
			Part *part=mType->getPart(i);
			
			subParts[i].init(mType->getGraphicIndexForPart(i),vec3(part->position[0],part->position[1],part->position[2]),vec3(part->orienation[0],part->orienation[1],part->orienation[2]),part->scale);

		}
}

void XPModel::setOwner(unsigned char own){
	owner=own;
}

unsigned char XPModel::getOwner(){
	return owner;
}

unsigned char XPModel::getAction(){
	return action;
}

unsigned char XPModel::getPreviousAction(){
	return previousAction;
}

float XPModel::getAnimationTime(){
	return animationTime;
}

void XPModel::setAction(unsigned char act){
	action=act;
}
void XPModel::setPreviousAction(unsigned char act){
	previousAction=act;
}

void XPModel::setAnimationTime(float aTime){
	animationTime=aTime;
}