#include "mapent.h"
#include "vec.h"
#include "algebra.h"
#include "PlayerList.h"
#include "Player.h"


void PlayerList::addPlayer(Player *player){
	int id=player->getPlayerID();
	if(playerVector[id]!=NULL){
		delete playerVector[id];
	}
	playerVector[id]=player;
	
}

void PlayerList::freeList(){
	for (int i= 0; i < playerVector.size(); i++){
		if(playerVector[i]!=NULL){
			delete playerVector[i];
		}
	}
	playerVector.clear();
}

Player *PlayerList::getPlayer(int index){
	return playerVector[index];
}

int PlayerList::getLength(){
	return playerVector.size();
}

PlayerList::~PlayerList(){
	freeList();

}

PlayerList::PlayerList(){
	for(int i=0;i<MAX_CLIENTS;i++){
		playerVector.push_back(NULL);
	}
}

void PlayerList::removePlayer(int id){
	if(playerVector[id]!=NULL){
		delete playerVector[id];
		playerVector[id]=NULL;
	}

}

void PlayerList::updateAnimationTime(float increment){
	for (int i= 0; i < playerVector.size(); i++){
		if(playerVector[i]!=NULL){
			float aTime=playerVector[i]->getAnimationTime();
			aTime+=increment;
			playerVector[i]->setAnimationTime(aTime);
			
		}
	}
}