#ifndef _BOXH_
#define _BOXH_

#include "matrix.h"
#include "vec.h"
#include "sphere.h"
#include "point.h"
#include "plane.h"
#include "transform.h"

typedef matrix<float> Matrix;


// collision matrices
static Matrix akA(3,3), akB(3,3);
static Matrix afEA(3,1), afEB(3,1);
static Matrix kD(3,1);
static Matrix aafC(3,3), aafAbsC(3,3);  // matrix C = A^T B, c_{ij} = Dot(A_i,B_j)   |c_{ij}|
static Matrix afAD(3,1), afBD(3,1);  // Dot(A_i,D)   Dot(B_i,D)
static Matrix box_rot(3,3);
static Matrix box_mx(3,1), box_ml(3,1), box_Ob(3,1), box_O(3,1);
static Matrix box_dummy(4,4);

static vec3_t segdir, seg_center, diff;
static vec3_t abs_segdir, abs_diff, abs_cross;




class Box
{
public:
	Box ();
	Box (int* c);	//extreme co-ords
	Box (float* c);

	bool collide ( Box b );
	bool collide ( Sphere s );
	bool collide ( Point p );
	bool collide ( float x, float y, float z);
	bool collide ( float x, float y, float z, float dx, float dy, float dz, float ln);

	void translate ( float dx, float dy, float dz );
	void scale ( float s);
	void rotateX (float alpha);
	void rotateY (float alpha);
	void rotateZ (float alpha);
	void transform (Transform T);
	void transform (Matrix M);
	
	void setAxes(Matrix M);
	void setCenter(Matrix M);
	void setCenter( float x, float y, float z );
	void setSize(Matrix M);
	void setSize( float x, float y, float z );	
	void setZAxis ( float x, float y, float z );

	Matrix getAxes();
	Matrix getCenter();
	Matrix getSize();
	Matrix getExtent();
	void print();
	void printSimple();

private:
	Matrix axes;
	Matrix center;
	Matrix size;	
};


#endif