#ifndef _BSPDATAMODELH_
#define _BSPDATAMODELH_

#include "handlers.h"

#define BSPHEADERID  (*(int*)"IBSP")
#define BSPVERSION 46

#define SHADERS_ADD 100  /* Room for additional shaders */

typedef enum
{
    ENTITIES,
    SHADERREFS,
#ifdef SERVERCODE
	PLANESERVER,
#else
    PLANES,
#endif
    NODES,
    LEAFS,
    LFACES,
    BRUSH_LIST,
    MODELS,
    BRUSHES,
    BRUSH_SIDES,
    VERTS,
    ELEMS,
    FOGZONES,
    FACES,
    LIGHTMAPS,
    LIGHTGRID,
    VISIBILITY,
    NUM_LUMPS
};


#define READLUMP(lump,val) r_num##val = readlump(lump, (void**)&r_##val, sizeof(*(r_##val)))



#ifndef SERVERCODE

#define NUM_MATRIX_TEXTURES 5
#ifdef WIN32
#define MATRIXDIR "resources\\images\\matrix"
#else
#define MATRIXDIR "resources/images/matrix"
#endif


/*skybox info*/
#define SIDE_SIZE 9
#define POINTS_LEN (SIDE_SIZE*SIDE_SIZE)
#define ELEM_LEN ((SIDE_SIZE-1)*(SIDE_SIZE-1)*6)

#define SPHERE_RAD  10.0
#define EYE_RAD      9.0

#define SCALE_S 4.0  /* Arbitrary (?) texture scaling factors */
#define SCALE_T 4.0 
/* end of skybox info */

/* mesh info */
#define LEVEL_WIDTH(lvl) ((1 << (lvl+1)) + 1)


/* end of mesh info */

/* shader info */

	//helpers
	void shader_cull(BSPDataModel *bspDM, shader_t *shader, shaderpass_t *pass, int numargs, char **args);
	void shader_surfaceparm(BSPDataModel *bspDM, shader_t *shader, shaderpass_t *pass, int numargs, char **args);
	void shader_skyparms(BSPDataModel *bspDM, shader_t *shader, shaderpass_t *pass, int numargs, char **args);
	void shader_nomipmaps(BSPDataModel *bspDM, shader_t *shader, shaderpass_t *pass, int numargs, char **args);
	void shader_deformvertexes(BSPDataModel *bspDM, shader_t *shader, shaderpass_t *pass, int numargs, char **args);
	void shaderpass_map(BSPDataModel *bspDM, shader_t *shader, shaderpass_t *pass, int numargs, char **args);
	void shaderpass_rgbgen(BSPDataModel *bspDM, shader_t *shader, shaderpass_t *pass, int numargs, char **args);
	void shaderpass_blendfunc(BSPDataModel *bspDM, shader_t *shader, shaderpass_t *pass, int numargs, char **args);
	void shaderpass_depthfunc(BSPDataModel *bspDM, shader_t *shader, shaderpass_t *pass, int numargs, char **args);
	void shaderpass_depthwrite(BSPDataModel *bspDM, shader_t *shader, shaderpass_t *pass, int numargs, char **args);
	void shaderpass_alphafunc(BSPDataModel *bspDM, shader_t *shader, shaderpass_t *pass, int numargs, char **args);
	void shaderpass_tcmod(BSPDataModel *bspDM, shader_t *shader, shaderpass_t *pass, int numargs, char **args);
	void shaderpass_animmap(BSPDataModel *bspDM, shader_t *shader, shaderpass_t *pass, int numargs, char **args);
	void shaderpass_clampmap(BSPDataModel *bspDM, shader_t *shader, shaderpass_t *pass, int numargs, char **args);
	void shaderpass_tcgen(BSPDataModel *bspDM, shader_t *shader, shaderpass_t *pass, int numargs, char **args);


/* end shader info */

/*begin tex info */
#define TEX_MISSING ((uint_t)-1)

#define IMG_BUFSIZE (1024*1024-8)
/*end tex info */


#endif //#ifndef SERVERCODE

class BSPDataModel
{
private:

	int r_nummodels, r_numverts, r_numplanes, r_numleafs, r_numnodes;
	int r_numshaders, r_numfaces, r_numlfaces, r_numelems;
	int r_lightmapsize;
	int r_numbrushsides, r_numbrushes, r_numlbrushes;
	int r_addshaderstart;

	model_t *r_models;
	vertex_t *r_verts;
	plane_t *r_planes;
	leaf_t *r_leafs;
	node_t *r_nodes;
	shaderref_t *r_shaderrefs;
	face_t *r_faces;
	int *r_lfaces;
	int *r_elems;	
	visibility_t *r_visibility;
	byte_t *r_lightmapdata;
	brushside_t *r_brushsides;
	brush_t *r_brushes;
	int *r_lbrushes;

	struct header
	{
		int id, ver;
		struct { int fileofs, filelen; } lump[NUM_LUMPS];
	} *bspheader;

	byte_t *bspdata;

	char rootPath[PATHLEN];
    int calls;
	/******************
		entity info from BSP
		*****************/

		int g_numentities;
	/* Key-value pair */
	typedef struct
	{
		char *key;
		char *val;
	} epair_t;

	/* Group of epairs */
	typedef struct
	{
		int firstpair;
		int numpairs;
	} entity_t;

	char *entity_buf;
	epair_t *epairs;
	entity_t *entities;
	int numepairs;

	

	/* end of entity info************************/

#ifndef SERVERCODE

	/* begin mesh ************/
	/* A mesh is a quadratic bezier patch, generated from control points.
	 */

	float r_subdivisiontol;  /* A lower values produces more vertexes
					   (smoother curve) */
	int r_maxmeshlevel;      /* Constraint on maximum num vertexes */
	int r_nummeshes;
	mesh_t *r_meshes;

	void mesh_create(face_t *face, mesh_t *mesh);
	void mesh_create_all();
	void mesh_free_all();
	//helpers
	int mesh_find_level(vec3_t *v);
	void mesh_find_size(int *numcp, vec3_t *cp, int *size);
	void mesh_fill_curve_3(int numcp, int size, int stride, vec3_t *p);
	void mesh_fill_curve_2(int numcp, int size, int stride, vec2_t *p);
	void mesh_fill_curve_c(int numcp, int size, int stride, colour_t *p);
	void mesh_fill_patch_3(int *numcp, int *size, vec3_t *p);
	void mesh_fill_patch_2(int *numcp, int *size, vec2_t *p);
	void mesh_fill_patch_c(int *numcp, int *size, colour_t *p);
	/*end of mesh *****************/


	/* skybox info ***********************/
	/* The skybox has 5 sides (no bottom) */
	enum
	{
		SKYBOX_TOP    = 0,
		SKYBOX_FRONT,
		SKYBOX_RIGHT,
		SKYBOX_BACK,
		SKYBOX_LEFT
	};

	typedef struct
	{
		int numpoints;
		vec3_t *points[5];     /* World coords */
		texcoord_t *tex_st[5]; /* Skybox mapped texture coords */
		int numelems;
		uint_t *elems;
	} skybox_t;

	skybox_t *r_skybox;

	void skybox_create();
	void skybox_free();
	//helpers
	void gen_box_side(int side, vec3_t orig, vec3_t drow, vec3_t dcol);
	void gen_box();
	void gen_elems();

	/* end of skybox info********************/

	/* begin shader info *******************/
	/* Shader flags */

	/* Gathers texture file names prior to texture loading */
	typedef struct
	{
		uint_t flags;
		char *fname;
	} texfile_t;

	int r_numtextures;
	shader_t *r_shaders;

	void shader_readall();
	void shader_freeall();

	uint_t shader_readfile(const char *path, uint_t bufsize, byte_t *buf);
	//helpers

	/* Maps shader keywords to functions */

	int shader_lookup(const char *name);
	void shader_skip();
	void shader_read();
	void shader_readpass(shader_t *shader, shaderpass_t *pass);
	void shader_parsetok(shader_t *shader, shaderpass_t *pass, shaderkey_t *keys, char *tok);
	void shader_makedefaults();
	char* nexttok();
	char* nextarg();
	char *shaderbuf, *curpos, *endpos;
	int *shaderfound;  /* Shader found in shader script files */

	uint_t shader_listshaders(uint_t bufsize, char *buf);

	/* end shader info *********************/

	/*begin lightmap info********************/
	int r_numlightmaptex;
	uint_t *r_lightmaptex;

	void lightmap_loadobjs();
	void lightmap_freeobjs();
	/*end lightmap info **********************/

	/* begin texture info *********************/
	uint_t *r_textures;
	int r_lodbias;   /* "Texture quality" bias: zero is highest quality */
	float r_gamma;   /* RGB premultiplier to increase scene brightness */
	void *imgbuf;

	void tex_loadobjs();
	void tex_freeobjs();
	//helpers
	typedef struct
	{
		byte_t idlen;
		byte_t cmtype;
		byte_t imgtype;
		byte_t cmspec[5];
		ushort_t xorig, yorig;
		ushort_t width, height;
		byte_t pixsize;
		byte_t imgdesc;
	} tgaheader_t;

	int tga_readtex(const char *fname, byte_t **rgb, int *w, int *h, int *format);
	int jpg_readtex(const char *fname, byte_t **rgb, int *w, int *h, int *format);
	void tex_loadtexture(byte_t *rgb, int w, int h, int format, uint_t flags);
	//helpers
	//void jpg_noop(j_decompress_ptr cinfo);
	//bool jpg_fill_input_buffer(j_decompress_ptr cinfo);
	//void jpg_skip_input_data(j_decompress_ptr cinfo, long num_bytes);
	//void jpeg_mem_src(j_decompress_ptr cinfo, byte_t *mem, int len);
	/*end texture info *********************/

#endif //#ifndef SERVERCODE

	int readlump(int lump, void** mem, size_t elem);

#ifndef SERVERCODE	
	uint_t matrix_textures[NUM_MATRIX_TEXTURES];
#endif

public:
	BSPDataModel();
	~BSPDataModel();
	int load(const char *absPath, const char *relMapPath);

	// Entity functions 
	void entity_parse(int buflen, char *buf);
	void entity_free();
	const char* entity_value(int entity, const char *key);
	float entity_float(int entity, const char *key);
	void entity_vec3(int entity, const char *key, vec3_t vec);
	int getNumEntities();
	const char *getRootPath();

#ifndef SERVERCODE

	void BSPDataModel::inspect();

	int addshaderref(const char *shadername);

	//callback problems
	texfile_t *r_texfiles;
	inline void Syntax();
	void shader_parsefunc(char **args, shaderfunc_t *func);
	int shader_gettexref(const char *fname);
	void setMapQuality(int lodbias, float gamma);
	
	friend class RenderEngine;
#endif

#ifdef SERVERCODE
	int find_cluster(vec3_t pos);
	int classify_point(vec3_t p, int plane_n);
#endif
};

#endif





