#ifndef _SERVERMODELLISTH_
#define _SERVERMODELLISTH_

#include <vector>
#include "ServerModel.h"
class ServerModelList{


private:
	std::vector<ServerModel *> modelVector;

public:
	ServerModelList();
	void addModel(ServerModel *);
	int getLength();
	void freeList();
	void updatePosition(float increment);


	ServerModel *getModel(int index);
	ServerModel *getModelByID(int id);
	~ServerModelList();
	void removeModel(ServerModel *model);
	void removeModel(int id);
	void setModel(int index,ServerModel *model);
	void removeModel(int owner,int id);
	ServerModel *getModel(int owner,int index);

};


#endif