/*
This file was produced by 3D Exploration Plugin: CPP Export filter.

3D Exploration

Copyright (c) 1999-2000 X Dimension Software

WWW         http://www.xdsoft.com/explorer/
eMail       info@xdsoft.com
*/
#include <windows.h>
#include <GL\gl.h>
#include <GL\glu.h>

#include <math.h>

struct sample_MATERIAL{
 GLfloat ambient[3];
 GLfloat diffuse[3];
 GLfloat specular[3];
 GLfloat emission[3];
 GLfloat alpha;
 GLfloat phExp;
 int   texture;
};
struct sample_TEXTURE{
 char * name;
 GLint  id;
};

static sample_MATERIAL materials [4] = {
 {{1.0f,1.0f,1.0f},	{1.0f,1.0f,1.0f},	{1.0f,1.0f,1.0f},	{1.0f,1.0f,1.0f},	1.0f,8.0f,0}, //Material #1
 {{1.0f,1.0f,1.0f},	{1.0f,1.0f,1.0f},	{1.0f,1.0f,1.0f},	{1.0f,1.0f,1.0f},	1.0f,8.0f,1}, //Material #4
 {{1.0f,1.0f,1.0f},	{1.0f,1.0f,1.0f},	{1.0f,1.0f,1.0f},	{1.0f,1.0f,1.0f},	1.0f,8.0f,2}, //Material #7
 {{1.0f,1.0f,1.0f},	{1.0f,1.0f,1.0f},	{1.0f,1.0f,1.0f},	{1.0f,1.0f,1.0f},	1.0f,8.0f,3} //Material #10
};

static sample_TEXTURE texture_maps [4] = {
{"rocket_0.bmp",0},
{"rocket_1.bmp",0},
{"rocket_2.bmp",0},
{"rocket_3.bmp",0}
};

// 51 Verticies
// 56 Texture Coordinates
// 44 Normals
// 74 Triangles

static BYTE face_indicies[74][9] = {
// flash
	{1,0,2 ,0,1,2 ,0,1,2 }, {3,0,1 ,3,1,0 ,3,1,0 }, {5,3,1 ,4,3,0 ,4,3,0 },
	{4,3,5 ,5,3,4 ,5,3,4 }, {6,4,5 ,6,5,4 ,6,5,4 }, {7,6,5 ,7,6,4 ,7,6,4 },
	{8,6,7 ,8,6,7 ,8,6,7 }, {2,8,7 ,2,8,7 ,2,8,7 }, {7,1,2 ,7,0,2 ,7,0,2 },
	{5,1,7 ,4,0,7 ,4,0,7 }
// flare
	, {10,12,16 ,9,10,11 ,9,10,11 }, {11,12,10 ,12,10,9 ,12,10,9 },
	{9,11,10 ,13,12,9 ,13,12,9 }, {13,11,9 ,14,12,13 ,14,12,13 },
	{19,13,9 ,15,14,13 ,15,14,13 }, {18,13,19 ,16,14,15 ,16,14,15 },
	{22,18,19 ,17,16,15 ,17,16,15 }, {17,18,22 ,18,16,17 ,18,16,17 },
	{21,17,22 ,19,18,17 ,19,18,17 }, {16,17,21 ,11,18,19 ,11,18,19 },
	{20,16,21 ,20,11,19 ,20,11,19 }, {15,16,20 ,21,11,20 ,21,11,20 },
	{14,15,20 ,22,21,20 ,22,21,20 }, {10,15,14 ,9,21,22 ,9,21,22 },
	{9,10,14 ,13,9,22 ,13,9,22 }, {15,10,16 ,21,9,11 ,21,9,11 },
	{13,12,11 ,14,10,12 ,14,10,12 }, {17,12,13 ,18,10,14 ,18,10,14 },
	{18,17,13 ,16,18,14 ,16,18,14 }, {16,12,17 ,11,10,18 ,11,10,18 },
	{14,19,9 ,22,15,13 ,22,15,13 }, {21,19,14 ,19,15,22 ,19,15,22 },
	{20,21,14 ,20,19,22 ,20,19,22 }, {22,19,21 ,17,15,19 ,17,15,19 }
// rocket
	, {35,36,38 ,23,24,25 ,23,24,25 }, {32,36,35 ,26,24,23 ,26,24,23 },
	{31,32,35 ,27,26,23 ,27,26,23 }, {26,32,31 ,28,26,27 ,28,26,27 },
	{30,26,31 ,29,28,27 ,29,28,27 }, {24,26,30 ,30,28,29 ,30,28,29 },
	{25,26,24 ,31,28,30 ,31,28,30 }, {27,26,25 ,32,28,31 ,32,28,31 },
	{28,27,25 ,33,32,31 ,33,32,31 }, {33,27,28 ,34,32,33 ,34,32,33 },
	{23,33,28 ,35,34,33 ,35,34,33 }, {29,33,23 ,36,34,35 ,36,34,35 },
	{30,29,23 ,37,36,35 ,37,36,35 }, {34,29,30 ,38,36,37 ,38,36,37 },
	{38,29,34 ,39,36,38 ,39,36,38 }, {37,29,38 ,40,36,39 ,40,36,39 },
	{36,37,38 ,24,40,39 ,24,40,39 }, {32,37,36 ,26,40,24 ,26,40,24 },
	{23,24,30 ,35,41,37 ,35,41,37 }, {25,24,23 ,31,41,35 ,31,41,35 },
	{28,25,23 ,33,31,35 ,33,31,35 }, {34,35,38 ,42,23,25 ,42,23,43 },
	{31,35,34 ,27,23,42 ,27,23,42 }, {30,31,34 ,29,27,42 ,29,27,42 },
	{27,32,26 ,32,26,28 ,32,26,28 }, {33,32,27 ,34,26,32 ,34,26,32 },
	{33,37,32 ,34,40,26 ,34,40,26 }, {29,37,33 ,36,40,34 ,36,40,34 }
// fins
	, {40,39,41 ,43,43,43 ,44,45,46 }, {41,39,40 ,43,43,43 ,46,45,44 },
	{42,44,43 ,43,43,43 ,47,48,49 }, {43,44,42 ,43,43,43 ,49,48,47 },
	{50,43,42 ,43,43,43 ,50,49,47 }, {42,43,50 ,43,43,43 ,47,49,50 },
	{45,47,46 ,43,43,43 ,51,52,53 }, {46,47,45 ,43,43,43 ,53,52,51 },
	{49,46,45 ,43,43,43 ,54,53,51 }, {45,46,49 ,43,43,43 ,51,53,54 },
	{39,41,48 ,43,43,43 ,45,46,55 }, {48,41,39 ,43,43,43 ,55,46,45 }
};
static GLfloat vertices [51][3] = {
{-0.161499f,0.40407f,0.233204f},{0.00645995f,0.232881f,0.160207f},{-0.161499f,0.000322997f,0.466408f},
{-0.161499f,0.40407f,-0.233204f},{-0.161499f,0.000322997f,-0.466408f},{0.00645995f,0.000322997f,-0.24354f},
{-0.161499f,-0.40407f,-0.233204f},{0.00645995f,-0.232881f,0.160207f},{-0.161499f,-0.40407f,0.233204f},
{-0.0755814f,-0.0507106f,-0.00193798f},{-0.0755814f,-0.000322997f,0.0471576f},{-0.0329457f,-0.000322997f,-0.00193798f},
{-0.0755814f,0.0500646f,-0.00193798f},{-0.0755814f,-0.000322997f,-0.0523256f},{-0.187339f,-0.0778424f,0.0355297f},
{-0.187339f,-0.000322997f,0.0736434f},{-0.187339f,0.0771964f,0.0355297f},{-0.187339f,0.0771964f,-0.0406977f},
{-0.187339f,-0.000322997f,-0.0788114f},{-0.187339f,-0.0778424f,-0.0406977f},{-0.31137f,-0.000322997f,0.0555556f},
{-0.5f,-0.000322997f,-0.00193798f},{-0.31137f,-0.000322997f,-0.0600775f},{0.475452f,-0.0306848f,0.00710594f},
{0.475452f,0.00355297f,0.0316537f},{0.5f,0.00419897f,-0.00258398f},{0.475452f,0.0390827f,0.00645995f},
{0.475452f,0.0255168f,-0.0303618f},{0.475452f,-0.0190568f,-0.0303618f},{0.433463f,-0.0416667f,0.0116279f},
{0.433463f,0.00355297f,0.0445736f},{0.433463f,0.0487726f,0.0116279f},{0.433463f,0.0313307f,-0.0413437f},
{0.433463f,-0.0242248f,-0.0413437f},{0.0187338f,0.00355297f,0.0445736f},{0.0187338f,0.0487726f,0.0116279f},
{0.0187338f,0.0313307f,-0.0413437f},{0.0187338f,-0.0242248f,-0.0413437f},{0.0187338f,-0.0416667f,0.0116279f},
{0.0187338f,0.00419897f,0.0445736f},{0.0303618f,-0.0410207f,0.0891473f},{0.122739f,-0.0423127f,0.0897933f},
{0.120155f,0.110142f,-0.00322997f},{0.0187338f,0.0397287f,-0.0148579f},{0.0271318f,0.110142f,-0.00258398f},
{0.120801f,-0.0500646f,-0.0949612f},{0.0187338f,-0.0326227f,-0.0148579f},{0.0271318f,-0.0500646f,-0.0943152f},
{0.158915f,0.00419897f,0.0445736f},{0.158915f,-0.0326227f,-0.0148579f},{0.158915f,0.0397287f,-0.0148579f}
};
static GLfloat normals [44][3] = {
{0.924227f,0.323654f,0.202614f},{0.739101f,0.576824f,0.347858f},{0.778255f,0.000128298f,0.627949f},
{0.82633f,0.491609f,-0.274772f},{0.939198f,0.000218769f,-0.343376f},{0.798609f,0.00024777f,-0.60185f},
{0.826472f,-0.491284f,-0.274925f},{0.924281f,-0.323476f,0.202652f},{0.73908f,-0.576694f,0.348116f},
{0.50458f,0.0f,0.863365f},{0.562035f,0.827098f,0.0049604f},{0.0416872f,0.782216f,0.621612f},
{0.99997f,0.0f,0.00779496f},{0.562035f,-0.827098f,0.00496038f},{0.511525f,-1.23531e-08f,-0.859268f},
{0.0414053f,-0.783539f,-0.619961f},{0.0416773f,-8.42554e-09f,-0.999131f},{-0.218995f,0.0f,-0.975726f},
{0.0414053f,0.783539f,-0.619961f},{-1.0f,4.15006e-08f,-0.000707502f},{-0.214878f,1.74451e-08f,0.976641f},
{0.0442328f,0.0f,0.999021f},{0.0416872f,-0.782215f,0.621612f},{-0.625423f,0.778191f,0.0571434f},
{-0.776999f,0.369011f,-0.510003f},{-1.0f,0.0f,0.0f},{0.11341f,0.65844f,-0.744039f},
{0.0999964f,0.893361f,0.438073f},{0.496682f,0.827576f,0.261581f},{0.158523f,0.578029f,0.80047f},
{0.517977f,0.494785f,0.697773f},{0.999998f,0.000429222f,0.00192056f},{0.539078f,0.364608f,-0.759247f},
{0.603232f,-0.470064f,-0.644322f},{0.187069f,-0.580481f,-0.792494f},{0.497833f,-0.822992f,0.273581f},
{0.0919955f,-0.948036f,0.304572f},{0.160007f,-0.579267f,0.79928f},{0.0f,-0.588858f,0.808236f},
{-0.526091f,-0.809493f,0.260671f},{-0.294858f,-0.560133f,-0.774151f},{0.52251f,-0.496819f,0.692932f},
{-0.447214f,0.526691f,0.722909f},{0.57735f,0.57735f,0.57735f}
};
static GLfloat textures [56][2] = {
{0.25025f,0.671652f},{0.06742f,0.74975f},{0.5f,0.999501f},
{0.0674199f,0.25025f},{0.5f,0.239072f},{0.5f,0.000499547f},
{0.93258f,0.25025f},{0.74975f,0.671652f},{0.93258f,0.74975f},
{0.908545f,0.826471f},{0.908545f,0.499251f},{0.669785f,0.748604f},
{0.999501f,0.5f},{0.908545f,0.500749f},{0.908545f,0.173529f},
{0.669785f,0.251396f},{0.669785f,0.000499487f},{0.403631f,0.121591f},
{0.669785f,0.249104f},{0.000499517f,0.500001f},{0.403631f,0.87841f},
{0.669785f,0.999501f},{0.669785f,0.750896f},{0.214489f,0.828483f},
{0.400123f,0.828483f},{0.33327f,0.992956f},{0.403778f,0.225871f},
{0.218144f,0.225871f},{0.230624f,0.144054f},{0.0072119f,0.225871f},
{0.00579843f,0.144054f},{0.491282f,0.0161952f},{0.400686f,0.144054f},
{0.584903f,0.144054f},{0.578787f,0.225871f},{0.754223f,0.144054f},
{0.764421f,0.225871f},{0.971988f,0.225871f},{0.975643f,0.916202f},
{0.760766f,0.916202f},{0.578787f,0.828483f},{0.970575f,0.144054f},
{0.0072119f,0.828483f},{0.110317f,0.978336f},{0.0817436f,0.993719f},
{0.000499487f,0.75501f},{0.740596f,0.999501f},{0.723762f,0.496267f},
{0.0585779f,0.496787f},{0.000499696f,0.43377f},{0.996415f,0.43377f},
{0.726662f,0.000499487f},{0.059853f,0.00608408f},{0.000499666f,0.43377f},
{0.999501f,0.43377f},{0.998563f,0.75501f}
};
/*Material indicies*/
/*{material index,face count}*/
static int material_ref [4][2] = {
{0,10},
{1,24},
{2,28},
{3,12}
};
struct DIB2D{
 BITMAPINFOHEADER *Info;
 RGBQUAD *palette;
 BYTE    *bits;
};
struct GLTXTLOAD{
 GLint format;
 GLint perpixel;
 GLint Width;
 GLint Height;
 BYTE* bits;
};

/*
BOOL LoadDIB(char*file,DIB2D*dib)
Only trueColor and 256 color ucompressed bitmaps supported
*/
BOOL LoadDIB(char*file,DIB2D*dib)
 {
  BOOL result=FALSE;
  HANDLE hfile=CreateFile(file,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING ,FILE_ATTRIBUTE_NORMAL,0);
  if(hfile!=INVALID_HANDLE_VALUE)
    {
     DWORD readed;
     int size=GetFileSize(hfile,0);
     if(size>sizeof(BITMAPFILEHEADER))
      {
       BITMAPFILEHEADER bmfh;
       ReadFile(hfile,&bmfh,sizeof(BITMAPFILEHEADER),&readed,0);
       if((readed==sizeof(BITMAPFILEHEADER)) && (bmfh.bfType==0x4d42))
        {
         dib->Info=(BITMAPINFOHEADER*)(new BYTE[size-sizeof(BITMAPFILEHEADER)]);
         ReadFile(hfile,dib->Info,size-sizeof(BITMAPFILEHEADER),&readed,0);
         dib->bits=(BYTE*)(dib->Info+1);

         if(dib->Info->biBitCount==8)
          {
           dib->palette=(RGBQUAD*)dib->bits;
           if(dib->Info->biClrUsed)dib->bits+=dib->Info->biClrUsed*4;else dib->bits+=1024;
          }else{
           dib->palette=NULL;
          }
         result=TRUE;
        }
      }
     CloseHandle(hfile);
    }
   return result;
 };

long ScanBytes(int pixWidth, int bitsPixel) {
  return (((long)pixWidth*bitsPixel+31) / 32) * 4;
}

BOOL  ScaleImage(DIB2D&dib,GLTXTLOAD&p)
 {
   GLint glMaxTexDim;     // OpenGL maximum texture dimension
   GLint XDMaxTexDim=512; // user maximum texture dimension
   GLint minsize =2;
   double xPow2, yPow2;
   int ixPow2, iyPow2;
   int xSize2, ySize2;
   GLint m_iWidth=dib.Info->biWidth;
   GLint m_iHeight=dib.Info->biHeight;
   glGetIntegerv(GL_MAX_TEXTURE_SIZE, &glMaxTexDim);

   glMaxTexDim = min(XDMaxTexDim, glMaxTexDim);

   if (m_iWidth <= glMaxTexDim)
      xPow2 = log((double)m_iWidth) / log(2.0);
   else
      xPow2 = log((double)glMaxTexDim) / log(2.0);

   if (m_iHeight <= glMaxTexDim)
      yPow2 = log((double)m_iHeight) / log(2.0);
   else
      yPow2 = log((double)glMaxTexDim) / log(2.0);

   ixPow2 = (int)xPow2;
   iyPow2 = (int)yPow2;

   if (xPow2 != (double)ixPow2)
      ixPow2++;
   if (yPow2 != (double)iyPow2)
      iyPow2++;

   xSize2 = 1 << ixPow2;
   ySize2 = 1 << iyPow2;

   if(xSize2<minsize)xSize2=minsize;
   if(ySize2<minsize)ySize2=minsize;

   if(((xSize2==m_iWidth) && (ySize2==m_iHeight)))
   {
     if(dib.Info->biBitCount==24){
       p.format=GL_BGR_EXT;
       p.perpixel=3;
       return FALSE;
      }
     if(dib.Info->biBitCount==32)
      {
       p.format=GL_BGRA_EXT;
       p.perpixel=4;
       return FALSE;
      }
   }

   BYTE *bits=(BYTE *)dib.bits;
   if(dib.Info->biBitCount==8){

    // convert to TRUECOLOR
    int _perline=ScanBytes(8,m_iWidth);
    int perline=ScanBytes(24,m_iWidth);
    bits= new BYTE[perline*m_iHeight * sizeof(BYTE)];
    for(int y=0;y<m_iHeight;y++){
     BYTE *_b=((BYTE *)dib.bits)+y*_perline;
     BYTE *b=bits+y*perline;
     for(int x=0;x<m_iWidth;x++){
      RGBQUAD _p=dib.palette[*_b];
      _b++;
      *b=_p.rgbBlue;b++;
      *b=_p.rgbGreen;b++;
      *b=_p.rgbRed;b++;
     }
    }
   }
   BOOL isAlpha=(dib.Info->biBitCount==32);
   int _mem_size=xSize2 * ySize2 *  sizeof(BYTE);
   if(isAlpha){
         _mem_size*=4;
          p.perpixel=4;
          p.format=GL_BGRA_EXT;
          }else {
          _mem_size*=3;
          p.perpixel=3;
          p.format=GL_BGR_EXT;
          }
   BYTE *pData = (BYTE*)new BYTE[_mem_size];
   if (!pData) return FALSE;

   if(isAlpha){
   gluScaleImage(GL_BGRA_EXT, m_iWidth, m_iHeight,
                 GL_UNSIGNED_BYTE, bits,
                 xSize2, ySize2, GL_UNSIGNED_BYTE, pData);
   }
   else
   gluScaleImage(GL_RGB, m_iWidth, m_iHeight,
                 GL_UNSIGNED_BYTE, bits,
                 xSize2, ySize2, GL_UNSIGNED_BYTE, pData);


   if(bits!=dib.bits)delete bits;
//   m_pBits = pData;
   m_iWidth = xSize2 ;
   m_iHeight = ySize2 ;
   p.Width=m_iWidth;
   p.Height=m_iHeight;
   p.bits=pData;

   return TRUE ;
 }
void LoadTexture(char*filename)
 {
  DIB2D dib;
  GLTXTLOAD load;
  if(LoadDIB(filename,&dib))
   {

	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

    if(ScaleImage(dib,load))
     {
   glTexImage2D(GL_TEXTURE_2D,0,load.perpixel,
                load.Width,load.Height,0,
                load.format,GL_UNSIGNED_BYTE,
                load.bits);
                delete load.bits;
     }else{

   glTexImage2D(GL_TEXTURE_2D,0,load.perpixel,
                dib.Info->biWidth,dib.Info->biHeight,
                0,load.format,GL_UNSIGNED_BYTE,dib.bits);
     }
   delete dib.Info;
   }

  //DeleteObject(hbitmap);
 };


void MyMaterial(GLenum mode,GLfloat *f,GLfloat alpha)
{
 GLfloat d[4];
 d[0]=f[0];
 d[1]=f[1];
 d[2]=f[2];
 d[3]=alpha;
 glMaterialfv (GL_FRONT_AND_BACK,mode,d);
}
/*
 *  SelectMaterial uses OpenGL commands to define facet colors.
 *
 *  Returns:
 *    Nothing
 */

void SelectMaterial(int i)
{
  //
  // Define the reflective properties of the 3D Object faces.
  //
  glEnd();
  GLfloat alpha=materials[i].alpha;
  MyMaterial (GL_AMBIENT, materials[i].ambient,alpha);
  MyMaterial (GL_DIFFUSE, materials[i].diffuse,alpha);
  MyMaterial (GL_SPECULAR, materials[i].specular,alpha);
  MyMaterial (GL_EMISSION, materials[i].emission,alpha);
  glMaterialf (GL_FRONT_AND_BACK,GL_SHININESS,materials[i].phExp);
	glEnd();
	if(materials[i].texture>-1)
	{
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D,texture_maps[materials[i].texture].id);
	}
	else
	glDisable(GL_TEXTURE_2D);
	glBegin(GL_TRIANGLES);

  glBegin(GL_TRIANGLES);

};

GLint Gen3DObjectList()
{
 int i;
 int j;

for(i=0;i<4;i++)
  {
    GLuint texture_name;
    glGenTextures(1,&texture_name);
    texture_maps[i].id=texture_name;
    glBindTexture(GL_TEXTURE_2D,texture_name);
    LoadTexture(texture_maps[i].name);
  }

 GLint lid=glGenLists(1);
	int mcount=0;
	int mindex=0;
   glNewList(lid, GL_COMPILE);

    glBegin (GL_TRIANGLES);
      for(i=0;i<sizeof(face_indicies)/sizeof(face_indicies[0]);i++)
       {
      if(!mcount)
       {
        SelectMaterial(material_ref[mindex][0]);
        mcount=material_ref[mindex][1];
        mindex++;
       }
       mcount--;
       for(j=0;j<3;j++)
        {
          int vi=face_indicies[i][j];
          int ni=face_indicies[i][j+3];//Normal index
          int ti=face_indicies[i][j+6];//Texture index
           glNormal3f (normals[ni][0],normals[ni][1],normals[ni][2]);
           glTexCoord2f(textures[ti][0],textures[ti][1]);
           glVertex3f (vertices[vi][0],vertices[vi][1],vertices[vi][2]);
        }
       }
    glEnd ();

   glEndList();
   return lid;
};

float sizex,sizey;
LONG WINAPI WndProc (HWND, UINT, WPARAM, LPARAM);
GLsizei glnWidth, glnHeight;
GLdouble gldAspect;
void SetDCPixelFormat (HWND,HDC);
void InitializeRC (void);
void DrawScene (HDC, UINT,UINT);

HPALETTE hPalette = NULL;
GLfloat nSize = 0.0f;
GLfloat nCol = 0.0f;
GLfloat nTop = 1.0f;
GLfloat nBottom = 0.0f;
int bFlag = 1;
char wndname[256]="";

GLint hlist=0;

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{
    static char szAppName[] = "3D Exploration Open GL test application";
    WNDCLASS wc;
    HWND hwnd;
    MSG msg;


    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = (WNDPROC) WndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon (NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor (NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
    wc.lpszMenuName = NULL;
    wc.lpszClassName = szAppName;

    RegisterClass (&wc);

    hwnd = CreateWindow (szAppName, szAppName,
        WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN | WS_CLIPSIBLINGS,
        CW_USEDEFAULT, CW_USEDEFAULT, 200, 200,
        HWND_DESKTOP, NULL, hInstance, NULL);

    hlist=Gen3DObjectList();

    ShowWindow (hwnd, nCmdShow);
    UpdateWindow (hwnd);

    while (GetMessage (&msg, NULL, 0, 0)) {
        TranslateMessage (&msg);
        DispatchMessage (&msg);
    }
    return msg.wParam;
}

/*
 *  WndProc processes messages to the main window.
 */

LONG WINAPI WndProc (HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    static HDC hdc;
    static HGLRC hrc;
    PAINTSTRUCT ps;
    static UINT nAngle = 0;
    static UINT nAngle2 = 0;
    static UINT nTimer;
    int n;
                
    switch (msg) {
    
    case WM_CREATE:
        //
        // Create a rendering context and set a timer.
        //
        hdc = GetDC (hwnd);
        SetDCPixelFormat (hwnd,hdc);
        hrc = wglCreateContext (hdc);
        wglMakeCurrent (hdc, hrc);
        InitializeRC ();
        nTimer = SetTimer (hwnd, 1, 1, NULL);
        return 0;

    case WM_SIZE:
        //
        // Redefine the viewing volume and viewport when the window size
        // changes.
        //
        glnWidth = (GLsizei) LOWORD (lParam);
        glnHeight = (GLsizei) HIWORD (lParam);

        return 0;

    case WM_PAINT:{
        //
        // Draw the scene.
        //
        BeginPaint (hwnd, &ps);
        DrawScene (hdc, nAngle,nAngle2);
        EndPaint (hwnd, &ps);

        }return 0;

    case WM_TIMER:
        //
        // Update the rotation angle and force a repaint.
        //
        nAngle += 2;
        if (nAngle >= 360)
            nAngle -= 360;
        nAngle2 += 1;
        if (nAngle2 >= 360)
            nAngle2 -= 360;

		if (bFlag == 1)
			nSize += 0.05f;
			nCol += 0.01f;
			if (nSize >= nTop)
				bFlag = 0;

		if (bFlag == 0)
			nSize -= 0.05f;
			nCol -= 0.01f;
			if (nSize <= nBottom)
				bFlag = 1;

		InvalidateRect (hwnd, NULL, FALSE);
        return 0;

    case WM_QUERYNEWPALETTE:
        //
        // If the program is using a color palette, realize the palette
        // and update the client area when the window receives the input
        // focus.
        //
        if (hPalette != NULL) {
            if (n = RealizePalette (hdc))
                InvalidateRect (hwnd, NULL, FALSE);
            return n;
        }
        break;

    case WM_PALETTECHANGED:
        //
        // If the program is using a color palette, realize the palette
        // and update the colors in the client area when another program
        // realizes its palette.
        //
        if ((hPalette != NULL) && ((HWND) wParam != hwnd)) {
            if (RealizePalette (hdc))
                UpdateColors (hdc);
            return 0;
        }
        break;

    case WM_DESTROY:
        //
        // Clean up and terminate.
        //
        wglMakeCurrent (NULL, NULL);
        wglDeleteContext (hrc);
        ReleaseDC (hwnd, hdc);
        if (hPalette != NULL)
            DeleteObject (hPalette);
        KillTimer (hwnd, nTimer);
        PostQuitMessage (0);
        return 0;
    }
    return DefWindowProc (hwnd, msg, wParam, lParam);
}

/*
 *  SetDCPixelFormat sets the pixel format for a device context in
 *  preparation for creating a rendering context.
 *
 *  Input parameters:
 *    hdc = Device context handle
 *
 *  Returns:
 *    Nothing
 */

void SetDCPixelFormat (HWND hwnd,HDC hdc)
{
    HANDLE hHeap;
    int nColors, i;
    LPLOGPALETTE lpPalette;
    BYTE byRedMask, byGreenMask, byBlueMask;

    static PIXELFORMATDESCRIPTOR pfd = {
        sizeof (PIXELFORMATDESCRIPTOR),             // Size of this structure
        1,                                          // Version number
        PFD_DRAW_TO_WINDOW |                        // Flags
        PFD_SUPPORT_OPENGL |
        PFD_GENERIC_ACCELERATED|
        PFD_DOUBLEBUFFER,
        PFD_TYPE_RGBA,                              // RGBA pixel values
        24,                                         // 24-bit color
        0, 0, 0, 0, 0, 0,                           // Don't care about these
        0, 0,                                       // No alpha buffer
        0, 0, 0, 0, 0,                              // No accumulation buffer
        32,                                         // 32-bit depth buffer
        0,                                          // No stencil buffer
        0,                                          // No auxiliary buffers
        PFD_MAIN_PLANE,                             // Layer type
        0,                                          // Reserved (must be 0)
        0, 0, 0                                     // No layer masks
    };

    int nPixelFormat;

    nPixelFormat = ChoosePixelFormat (hdc, &pfd);
    SetPixelFormat (hdc, nPixelFormat, &pfd);

    if (pfd.dwFlags & PFD_NEED_PALETTE) {
        nColors = 1 << pfd.cColorBits;
        hHeap = GetProcessHeap ();

        (LPLOGPALETTE) lpPalette = (LPLOGPALETTE)HeapAlloc (hHeap, 0,
            sizeof (LOGPALETTE) + (nColors * sizeof (PALETTEENTRY)));

        lpPalette->palVersion = 0x300;
        lpPalette->palNumEntries = nColors;

        byRedMask = (1 << pfd.cRedBits) - 1;
        byGreenMask = (1 << pfd.cGreenBits) - 1;
        byBlueMask = (1 << pfd.cBlueBits) - 1;

        for (i=0; i<nColors; i++) {
            lpPalette->palPalEntry[i].peRed =
                (((i >> pfd.cRedShift) & byRedMask) * 255) / byRedMask;
            lpPalette->palPalEntry[i].peGreen =
                (((i >> pfd.cGreenShift) & byGreenMask) * 255) / byGreenMask;
            lpPalette->palPalEntry[i].peBlue =
                (((i >> pfd.cBlueShift) & byBlueMask) * 255) / byBlueMask;
            lpPalette->palPalEntry[i].peFlags = 0;
        }

        hPalette = CreatePalette (lpPalette);
        HeapFree (hHeap, 0, lpPalette);

        if (hPalette != NULL) {
            SelectPalette (hdc, hPalette, FALSE);
            RealizePalette (hdc);
        }
    }
}

/*
 *  InitializeRC initializes the current rendering context.
 *
 *  Input parameters:
 *    None
 *
 *  Returns:
 *    Nothing
 */


void InitializeRC (void)
{
    GLfloat glfLightAmbient[] = { 0.1f, 0.1f, 0.1f, 1.0f };
    GLfloat glfLightDiffuse[] = { 1.2f, 1.2f, 1.2f, 1.0f };
    GLfloat glfLightSpecular[] = { 0.9f, 0.9f, 0.9f, 1.0f };

    //
    // Add a light to the scene.
    //

    glLightfv (GL_LIGHT0, GL_AMBIENT, glfLightAmbient);
    glLightfv (GL_LIGHT0, GL_DIFFUSE, glfLightDiffuse);
    glLightfv (GL_LIGHT0, GL_SPECULAR, glfLightSpecular);
    glEnable (GL_LIGHTING);
    glEnable (GL_LIGHT0);

    //
    // Enable depth testing and backface culling.
    //

    glEnable (GL_DEPTH_TEST);    
    glDisable (GL_CULL_FACE);
    glLightModeli(GL_LIGHT_MODEL_TWO_SIDE ,1);

}

/*
 *  DrawScene uses OpenGL Display list to draw a object.
 *
 *  Input parameters:
 *    hdc = Device context handle
 *    nAngle = Angle of rotation for object
 *
 *  Returns:
 *    Nothing
 */

void DrawScene (HDC hdc, UINT nAngle,UINT nAngle2)
{
        sizex=glnWidth;
        sizey=glnHeight;

        gldAspect = (GLdouble) glnWidth / (GLdouble) glnHeight;

        glMatrixMode (GL_PROJECTION);
        glLoadIdentity ();
        gluPerspective (30.0,           // Field-of-view angle
                        gldAspect,      // Aspect ratio of viewing volume
                        1.0,            // Distance to near clipping plane
                        10.0);          // Distance to far clipping plane

        glViewport (0, 0, glnWidth, glnHeight);
    //
    // Clear the color and depth buffers.
    //
    glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

    //
    // Define the modelview transformation.
    //
    glMatrixMode (GL_MODELVIEW);
    glLoadIdentity ();
    glTranslatef (0.0f, 0.0f, -8.0f);
    glRotatef (30.0f, 1.0f, 0.0f, 0.0f);
    glRotatef ((GLfloat) nAngle, 0.0f, 1.0f, 0.0f);
    glRotatef ((GLfloat) nAngle2, 1.0f, 0.0f, 0.0f);
    glScalef (nSize+2.5f,nSize+2.5f,nSize+2.5f);  

	int mcount=0;
	int mindex=0;
	
    glCallList(hlist);
    //
    // Swap the buffers.
    //
    glFlush();
    SwapBuffers (hdc);
};