#ifndef _SOUNDMANAGERH_
#define _SOUNDMANAGERH_

#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include "fmod.h"
#include "SoundObject.h"

#define CHANNEL_NO_PRIORITY        0
#define CHANNEL_LOW_PRIORITY      63
#define CHANNEL_MEDIUM_PRIORITY  127
#define CHANNEL_HIGH_PRIORITY	 191
#define CHANNEL_HIGHEST_PRIORITY 254
#define	CHANNEL_BACKGROUND		 255

class SoundManager
{
public:
	void initializeSound ();
	SoundManager ();	

	void stop ();	
	void close();

	int playSound (SoundObject* sound);  // play sound at default vol, pan, priority
	int playSound (SoundObject* sound, int priority);  // search for channel
	int playSound (SoundObject* sound, float vol, float pan);  // search for channel, low pri
	int playSound (SoundObject* sound, int priority, float vol, float pan); //search for channel 
	int playSoundOnChannel (SoundObject* sound, int channelNum);  // force sound to channel

	int playDirectionalSound (SoundObject *sound, float alpha, float dist);
	int playDirectionalSound (SoundObject *sound, float dx, float dy, float myAlpha);
	int freeChannel (int channelNum);
	
	void setChannelProperties ( int channelNum, float vol, float pan, int loop );
	void setChannelVolume ( int channelNum, float vol);
	void setChannelPan ( int channelNum, float pan);
	void setChannelLoop ( int channelNum, int loop);

	void setDistFallOff (float d) { distFallOff = d; }
	void setDistCutOff  (float d) { distCutOff = d; }

	float getChannelVolume (int channelNum);
	float getChannelPan (int channelNum);
	int   getChannelLoop (int channelNum);
	int   getChannelStatus (int channelNum);

private:	
	int numVoices;
	float distFallOff;
	float distCutOff;
};


#endif
