#include "math.h"
#include "SoundManager.h"

void SoundManager::initializeSound()
{	
	numVoices = 32;
	FSOUND_SetOutput(-1);
	FSOUND_SetDriver(0);
	FSOUND_Init(44100, numVoices, 0);
}


SoundManager::SoundManager ()
{
	distFallOff = .5;
	distCutOff  = 10;
}

void SoundManager::stop()
{	
	FSOUND_StopSound(FSOUND_ALL);
}

int SoundManager::playSound(SoundObject* sound)
{
	int channelNum;
	
	channelNum = FSOUND_PlaySound (FSOUND_FREE, sound->getAudio());
	
	if (channelNum != -1){
		FSOUND_SetVolume (channelNum, 255);
		FSOUND_SetPan (channelNum, 127);
		FSOUND_SetPriority (channelNum, CHANNEL_NO_PRIORITY);
	}	
	return channelNum;
}

int SoundManager::playSound(SoundObject* sound, float vol, float pan)
{
	int channelNum;	
	channelNum = FSOUND_PlaySound (FSOUND_FREE, sound->getAudio());
	if (channelNum != -1){
		FSOUND_SetVolume (channelNum, (int)(vol*255));
		FSOUND_SetPan (channelNum, (int)(.5*(pan+1)*255));
		FSOUND_SetPriority (channelNum, CHANNEL_NO_PRIORITY);
	}	
	return channelNum;
}

int SoundManager::playSound(SoundObject* sound, int priority)
{
	int channelNum;	
	channelNum = FSOUND_PlaySound (FSOUND_FREE, sound->getAudio());
	if (channelNum != -1){
		FSOUND_SetVolume (channelNum, 255);
		FSOUND_SetPan (channelNum, 127);
		FSOUND_SetPriority (channelNum, priority);
		if (priority == CHANNEL_BACKGROUND)
			setChannelLoop (channelNum, 1);
	}	
	return channelNum;
}


int SoundManager::playSound(SoundObject* sound, int priority, float vol, float pan)
{
	int channelNum;	
	channelNum = FSOUND_PlaySound (FSOUND_FREE, sound->getAudio());
	if (channelNum != -1){
		FSOUND_SetVolume (channelNum, (int)(vol*255));
		FSOUND_SetPan (channelNum, (int)(.5*(pan+1)*255));
		FSOUND_SetPriority (channelNum, priority);
		if (priority == CHANNEL_BACKGROUND)
			setChannelLoop (channelNum, 1);
	}	
	return channelNum;
}

int SoundManager::playDirectionalSound (SoundObject *sound, float alpha, float dist)
{
	int channelNum;	
	channelNum = FSOUND_PlaySound (FSOUND_FREE, sound->getAudio());		
	if (channelNum != -1){
		float vol,pan;
		dist = fabs(dist);

		if (dist<distCutOff) vol = 1.0f;
		else vol = 1/(pow(dist,distFallOff));
		if (vol > 1) vol = 1;

		int priority = (int)(vol*254);

		pan = sin(alpha);

		FSOUND_SetVolume (channelNum, (int)(vol*255));
		FSOUND_SetPan (channelNum, (int)(.5*(pan+1)*255));
		FSOUND_SetPriority (channelNum, priority);
		if (priority == CHANNEL_BACKGROUND)
			setChannelLoop (channelNum, 1);
	}	
	return channelNum;
}

int SoundManager::playDirectionalSound (SoundObject *sound, float dx, float dy, float myAlpha)
{
	int channelNum;	
	channelNum = FSOUND_PlaySound (FSOUND_FREE, sound->getAudio());		
	if (channelNum != -1){
		float vol,pan, sndalpha;
		float dist = sqrt(dx*dx+dy*dy);
		sndalpha = atan2(dy,dx);

		if (dist<distCutOff) vol = 1.0f;
		else vol = 1/(pow(dist,distFallOff));
		if (vol > 1) vol = 1;

		int priority = (int)(vol*254);

		pan = sin(sndalpha-myAlpha);

		printf ("pan %f vol %f pri %d\n", pan, vol, priority);

		FSOUND_SetVolume (channelNum, (int)(vol*255));
		FSOUND_SetPan (channelNum, (int)(.5*(pan+1)*255));
		FSOUND_SetPriority (channelNum, priority);
		if (priority == CHANNEL_BACKGROUND)
			setChannelLoop (channelNum, 1);
	}	
	return channelNum;
}


int SoundManager::playSoundOnChannel(SoundObject* sound, int channelNum)
{	
	channelNum = FSOUND_PlaySound (channelNum, sound->getAudio());
	return channelNum;
}

int SoundManager::freeChannel(int channelNum)
{
	FSOUND_StopSound(channelNum);
	return channelNum;
}


void SoundManager::setChannelProperties ( int channelNum, float vol, float pan, int loop )
{
	setChannelVolume (channelNum , vol);
	setChannelPan    (channelNum , pan);
	setChannelLoop   (channelNum , loop);
}

void SoundManager::setChannelVolume(int channelNum, float vol)
{	
	FSOUND_SetVolume (channelNum, (int)(vol*255));
}

void SoundManager::setChannelPan(int channelNum, float pan)
{
	FSOUND_SetPan (channelNum, (int)(.5*(pan+1)*255));
}

void SoundManager::setChannelLoop(int channelNum, int loop)
{
	if (loop) FSOUND_SetLoopMode (channelNum, FSOUND_LOOP_NORMAL);
	else FSOUND_SetLoopMode (channelNum, FSOUND_LOOP_OFF);
}

float SoundManager::getChannelVolume(int channelNum)
{
	return (((float)FSOUND_GetVolume(channelNum))/255.0f);
}

float SoundManager::getChannelPan(int channelNum)
{
	return (2*(((float)FSOUND_GetPan(channelNum))/255.0f)-1.0f);	
}

int SoundManager::getChannelLoop(int channelNum)
{
	return 0;
}

int SoundManager::getChannelStatus(int channelNum)
{
	return FSOUND_GetPriority(channelNum);	
}

void SoundManager::close()
{
	FSOUND_Close();
}	


