#include "ServerModelList.h"

ServerModelList::ServerModelList(){
}


void ServerModelList::addModel(ServerModel *model){
		
	modelVector.push_back(model);
}

void ServerModelList::freeList(){
	std::vector<ServerModel *>::iterator iter=modelVector.begin();
	while(iter != modelVector.end()){
		delete *iter;
		iter++;
	}
	modelVector.clear();
}

ServerModel *ServerModelList::getModel(int index){
	return modelVector[index];
}

int ServerModelList::getLength(){
	return modelVector.size();
}

ServerModelList::~ServerModelList(){
	freeList();

}

void ServerModelList::updatePosition(float increment){

	std::vector<ServerModel *>::iterator iter=modelVector.begin();
	while(iter != modelVector.end()){
		
		(*iter)->moveAsOriented(increment);
		iter++;
	}

}

void ServerModelList::removeModel(ServerModel *model){
	std::vector<ServerModel *>::iterator iter=modelVector.begin();
	while(iter != modelVector.end()){
		if(*iter==model){
				modelVector.erase(iter);
				break;
		}
		iter++;
	}
	
}

void ServerModelList::removeModel(int id){
	std::vector<ServerModel *>::iterator iter=modelVector.begin();
	while(iter != modelVector.end()){
		if((*iter)->getID()==id){
				modelVector.erase(iter);
				break;
		}
		iter++;
	}
	
}

void ServerModelList::setModel(int index,ServerModel *model){
	modelVector[index]=model;
}

void ServerModelList::removeModel(int owner,int id){
	ServerModel *model;
	std::vector<ServerModel *>::iterator iter=modelVector.begin();
	while(iter != modelVector.end()){
		if(((*iter)->getID()==id)&&((*iter)->getOwner()==owner)){
				model=(*iter);
				modelVector.erase(iter);
				delete model;
				break;
		}
		iter++;
	}
	
}

ServerModel* ServerModelList::getModel(int owner,int id){
	std::vector<ServerModel *>::iterator iter=modelVector.begin();
	while(iter != modelVector.end()){
		if(((*iter)->getID()==id)&&((*iter)->getOwner()==owner)){
				return (*iter);
		}
		iter++;
	}
	return NULL;
}

