#define _UNICODE
#define UNICODE
#define STRICT
#include <windows.h>
#include <tchar.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "nl.h"
#include "App.h"
//Vars
int fWidth=0,fHeight=0;
RECT aRect;
HWND EditBox,ChatBox,HandleBox;
HINSTANCE GlobalInst;
const int MaxClients=50;
wchar_t ClientHandles[MaxClients][255];
NLsocket ServerSocket,ClientSocket[MaxClients],TempSocket;
int NumClients=0;
NLbyte TempStr[NL_MAX_STRING_LENGTH];
address_t ServerAddr,*IPs=NULL;
wchar_t *TextBuffer,*TempTextBuffer;
wchar_t MyHandle[255];
wchar_t ts[256],ts2[256];
char cts[256],cts2[256];
HWND HandleHWND,ConnectHWND,WindowHWND,PortHWND;
BOOL IsConnected=FALSE;
int ConnectTry=0,NumIPs=0;
BOOL IsServer=FALSE;
wchar_t ThePort[255];
void LoadINI()
{
	int i,tn;
	FILE *FP;
	FP=fopen("chat.ini","r");
    if(FP == NULL)
    {
        MessageBox (NULL, _TEXT("Could not open chat.ini file"), _TEXT("NLChat Error"), MB_OK | MB_ICONERROR);
        PostQuitMessage(0);
        return;
    }
	fgets(cts,255,FP);
	fgets(cts,255,FP);
	sscanf(cts,"%i",&tn);
	if(IPs)
		delete []IPs;
	IPs=new address_t[tn];
	NumIPs=tn;
	for(i=0;i<tn;i++)
	{
		fgets(cts,255,FP);
		nlStringToAddr(cts,IPs+i);
	}
	fgets(cts,255,FP);
	fgetws(MyHandle,255,FP);
	MyHandle[wcslen(MyHandle)-1]='\0';
	fgets(cts,255,FP);
	fgetws(ThePort,255,FP);
	ThePort[wcslen(ThePort)-1]='\0';
	fclose(FP);
}
void SaveINI()
{
	int i,tn;
	FILE *FP;
	FP=fopen("chat.ini","w");
	fprintf(FP,"[IPs]\n%i\n",NumIPs);
	for(i=0;i<NumIPs;i++)
	{
		nlAddrToString(&IPs[i],TempStr);
		tn=strcspn((char *)TempStr,":");
		TempStr[tn]='\0';
		fprintf(FP,"%s\n",TempStr);
	}
	fwprintf(FP,_TEXT("[Handle]\n%s\n"),MyHandle);
	fwprintf(FP,TEXT("[Port]\n%s\n"),ThePort);
	fclose(FP);
}
int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{
	
	WNDCLASS WindowClass;
	wchar_t szAppName[]=_TEXT("CHATPROG");
	HWND hWnd;
	MSG msg;
	//Window Init stuff
	
	//Window properties
	WindowClass.style=CS_HREDRAW|CS_VREDRAW;
	WindowClass.lpfnWndProc=WindowProc;
	WindowClass.cbClsExtra=0;
	WindowClass.cbWndExtra=0;
	WindowClass.hInstance=hInstance;
	WindowClass.hIcon=LoadIcon(hInstance,MAKEINTRESOURCE(IDI_APPMAIN));
	WindowClass.hCursor=LoadCursor(0,IDC_ARROW);
	WindowClass.hbrBackground=GetSysColorBrush(COLOR_3DFACE);
	WindowClass.lpszMenuName=MAKEINTRESOURCE(IDR_MENU1);
	WindowClass.lpszClassName=szAppName;
	//Window Properties

	RegisterClass(&WindowClass);
	//Woohoo! Make a window!!!
	GlobalInst=hInstance;
	hWnd=WindowHWND=CreateWindow(szAppName,_TEXT("HawkNL Chat"), WS_OVERLAPPEDWINDOW,0,0,640,480,NULL,NULL,hInstance,NULL);
	ShowWindow(hWnd,nCmdShow);
	UpdateWindow(hWnd);
	while(GetMessage(&msg,0,0,0)==TRUE)
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return msg.wParam;
}
void UnicodeATS(address_t *a,wchar_t *tts)
{
	nlAddrToString(a,cts);
	MultiByteToWideChar(CP_ACP, 0, cts, -1, tts, 1024);
}
void UnicodeSTA(wchar_t *tts,address_t *a)
{
	WideCharToMultiByte(CP_ACP, 0, tts, -1, cts, 1024, NULL, NULL);
	nlStringToAddr(cts,a);
}
				
void NoPortAddr(address_t *a,wchar_t *tts)
{
	int tn;
	nlAddrToString(a,cts);
	MultiByteToWideChar(CP_ACP, 0, cts, -1, tts, 1024);
	tn=wcscspn(tts,_TEXT(":"));
	tts[tn]='\0';
}
void GetLines(wchar_t *llts,int &NumLines,int &FirstN)
{
	int lts=wcslen(llts);
	FirstN=-1;
	NumLines=0;
	for(int i=0;i<lts;i++)
	{
		if(llts[i]=='\n')
		{
			NumLines++;
			if(FirstN==-1)
				FirstN=i;
		}
	}
}
void AddText(wchar_t *tts)
{
	int tmp,tmp2;
	SendMessage(ChatBox,WM_GETTEXT,255*255,(LPARAM)TempTextBuffer);
	GetLines(TempTextBuffer,tmp,tmp2);
	if(tmp>250)
		wcscpy(TextBuffer,TempTextBuffer+tmp2+1);
	else
		wcscpy(TextBuffer,TempTextBuffer);
	wcscat(TextBuffer,tts);
	SendMessage(ChatBox,WM_SETTEXT,0,(LPARAM)TextBuffer);
}
DWORD ConvertStrToIP(char *tts)
{
	int ip[4];
	sscanf(tts,"%i.%i.%i.%i",ip,ip+1,ip+2,ip+3);
	return MAKEIPADDRESS(ip[0],ip[1],ip[2],ip[3]);
}
void ConvertIPToStr(DWORD IP,char *tts)
{
	sprintf(tts,"%i.%i.%i.%i",FIRST_IPADDRESS(IP),SECOND_IPADDRESS(IP),THIRD_IPADDRESS(IP),FOURTH_IPADDRESS(IP));
}
void CALLBACK ServerTimer(HWND hWnd,UINT msg,UINT idtimer,DWORD sTime)
{
//	int i,j,tn;
	int i,j;
	TempSocket=nlAcceptConnection(ServerSocket);
	if(TempSocket!=NL_INVALID && NumClients<MaxClients)
	{
		ClientSocket[NumClients]=TempSocket;
		nlGetRemoteAddr(ClientSocket[NumClients],&ServerAddr);
		UnicodeATS(&ServerAddr,ts2);
		swprintf(ts,_TEXT("%s connected\r\n"),ts2);
		AddText(ts);
		for(i=0;i<NumClients;i++)
		{
			swprintf(ts,_TEXT("@%s"),ClientHandles[i]);
			nlWrite(ClientSocket[NumClients],ts,sizeof(ts));
		}
		swprintf(ts,_TEXT("@%s"),MyHandle);
		nlWrite(ClientSocket[NumClients],ts,sizeof(ts));
		NumClients++;
	}
	for(i=0;i<NumClients;i++)
	{
		if(nlRead(ClientSocket[i],ts,sizeof(ts))>0)
		{
            // NULL terminate string for safety
            ts[255]='\0';
			if(ts[0]=='@')
			{
				wcscpy(ClientHandles[i],ts+1);
				for(j=0;j<NumClients;j++)
				{
					swprintf(ts,_TEXT("@%s"),ClientHandles[i]);
					nlWrite(ClientSocket[j],ts,sizeof(ts));
				}
			}
			else if(ts[0]=='#')
			{
				for(j=0;j<NumClients;j++)
				{
					nlWrite(ClientSocket[j],ts,sizeof(ts));
				}
			}
			else if(ts[0]=='$')
			{
				ts[0]='#';
				for(j=0;j<NumClients;j++)
				{
					nlWrite(ClientSocket[j],ts,sizeof(ts));
				}
				for(j=i;j<NumClients-1;j++)
				{
					ClientSocket[j]=ClientSocket[j+1];
				}
				NumClients--;
			}
			else
			{
				AddText(ts);
				for(j=0;j<NumClients;j++)
				{
					if(j!=i)
						nlWrite(ClientSocket[j],ts,sizeof(ts));
				}
			}
		}
	}
}
void CALLBACK ClientTimer(HWND hWnd,UINT msg,UINT idtimer,DWORD sTime)
{
	if(!IsConnected)
	{
		ConnectTry++;
		if(nlRead(ServerSocket,ts,1)>0)
		{
			AddText(_TEXT("Connected!\r\n"));
			IsConnected=TRUE;
			ConnectTry=0;
		}
		if(ConnectTry>=200)
		{
			ConnectTry=0;
			AddText(_TEXT("Server not answering, try again later.\r\n"));
			KillTimer(hWnd,idtimer);
			nlClose(ServerSocket);
		}
	}
	else
	{
		if(nlRead(ServerSocket,ts,sizeof(ts))>0)
		{
            // NULL terminate string for safety
            ts[255]='\0';
			if(wcscmp(ts,_TEXT("Server Disconnected\r\n"))==0)
			{
				AddText(ts);
				SendMessage(hWnd,WM_COMMAND,MAKEWPARAM(ID_CONNECT_DISCONNECT,0),0);
			}
			else if(ts[0]=='@')
			{
				wcscpy(ts2,ts+1);
				SendMessage(HandleBox,LB_ADDSTRING,0,(LPARAM)ts2);
			}
			else if(ts[0]=='#')
			{
				wcscpy(ts2,ts+1);
				SendMessage(HandleBox,LB_DELETESTRING,SendMessage(HandleBox,LB_FINDSTRING,-1,(LPARAM)ts2),0);
			}
			else
				AddText(ts);
		}
	}
}
int CALLBACK PortProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
//	int i;
	switch(message)
	{
	case WM_INITDIALOG:
		SendMessage(GetDlgItem(hWnd,IDC_THEPORT),WM_SETTEXT,0,(LPARAM)ThePort);
		return TRUE;
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDOK:
			if(IsConnected)
			{
				MessageBox(hWnd,TEXT("Please disconnect first!"),TEXT("Chat"),MB_OK|MB_ICONERROR);
			}
			else
				SendMessage(GetDlgItem(hWnd,IDC_THEPORT),WM_GETTEXT,255,(LPARAM)ThePort);
			SendMessage(hWnd,WM_DESTROY,0,0);
			return TRUE;
		case IDCANCEL:
			SendMessage(hWnd,WM_DESTROY,0,0);
			return TRUE;
		case IDC_THEPORT:
			if(HIWORD(wParam)==EN_CHANGE)
			{
				SendMessage(GetDlgItem(hWnd,IDC_THEPORT),WM_GETTEXT,256,(LPARAM)ts);
				if(ts[wcslen(ts)-1]=='\n')
				{
					ts[wcslen(ts)-2]='\0';
					SendMessage(GetDlgItem(hWnd,IDC_THEPORT),WM_SETTEXT,0,(LPARAM)ts);
					SendMessage(hWnd,WM_COMMAND,MAKEWPARAM(IDOK,0),0);
				}
			}
			return TRUE;
		};
		return TRUE;
	case WM_DESTROY:
		EndDialog(hWnd,0);
		return TRUE;
	};
	return FALSE;
}
int CALLBACK HandleProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
	int i;
	switch(message)
	{
	case WM_INITDIALOG:
		SendMessage(GetDlgItem(hWnd,IDC_HANDLEEDIT),WM_SETTEXT,0,(LPARAM)MyHandle);
		return TRUE;
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDOK:
			if(IsConnected)
			{
				if(IsServer)
				{
					for(i=0;i<NumClients;i++)
					{
						swprintf(ts,_TEXT("#%s"),MyHandle);
						nlWrite(ClientSocket[i],ts,sizeof(ts));
						SendMessage(GetDlgItem(hWnd,IDC_HANDLEEDIT),WM_GETTEXT,255,(LPARAM)MyHandle);
						swprintf(ts,_TEXT("@%s"),MyHandle);
						nlWrite(ClientSocket[i],ts,sizeof(ts));
					}
				}
				else
				{
					swprintf(ts,_TEXT("#%s"),MyHandle);
					nlWrite(ServerSocket,ts,sizeof(ts));
					SendMessage(GetDlgItem(hWnd,IDC_HANDLEEDIT),WM_GETTEXT,255,(LPARAM)MyHandle);
					swprintf(ts,_TEXT("@%s"),MyHandle);
					nlWrite(ServerSocket,ts,sizeof(ts));
				}
			}
			else
				SendMessage(GetDlgItem(hWnd,IDC_HANDLEEDIT),WM_GETTEXT,255,(LPARAM)MyHandle);
			SendMessage(hWnd,WM_DESTROY,0,0);
			return TRUE;
		case IDCANCEL:
			SendMessage(hWnd,WM_DESTROY,0,0);
			return TRUE;
		case IDC_HANDLEEDIT:
			if(HIWORD(wParam)==EN_CHANGE)
			{
				SendMessage(GetDlgItem(hWnd,IDC_HANDLEEDIT),WM_GETTEXT,256,(LPARAM)ts);
				if(ts[wcslen(ts)-1]=='\n')
				{
					ts[wcslen(ts)-2]='\0';
					SendMessage(GetDlgItem(hWnd,IDC_HANDLEEDIT),WM_SETTEXT,0,(LPARAM)ts);
					SendMessage(hWnd,WM_COMMAND,MAKEWPARAM(IDOK,0),0);
				}
			}
			return TRUE;
		};
		return TRUE;
	case WM_DESTROY:
		EndDialog(hWnd,0);
		return TRUE;
	};
	return FALSE;
}
void ChangeChatFont()
{
	LOGFONT TheFont;
	HFONT FontHandle;
//	CHARFORMAT RECF;
	CHOOSEFONT cf;
	FontHandle=(HFONT)SendMessage(EditBox,WM_GETFONT,0,0);
	GetObject(FontHandle,sizeof(TheFont),&TheFont);
	cf.lStructSize=sizeof(cf); 
	cf.hwndOwner=WindowHWND; 
	cf.hDC=0; 
	cf.lpLogFont=&TheFont; 
	cf.iPointSize=100; 
	cf.Flags=CF_SCREENFONTS|CF_LIMITSIZE|CF_INITTOLOGFONTSTRUCT; 
	cf.rgbColors=0; 
	cf.lCustData=0; 
	cf.lpfnHook=0; 
	cf.lpTemplateName=0; 
	cf.hInstance=GlobalInst; 
	cf.lpszStyle=0; 
	cf.nFontType=0; 
	cf.nSizeMin=1; 
	cf.nSizeMax=200; 
	
	if(ChooseFont(&cf)!=0)
	{
		SendMessage(ChatBox,WM_SETFONT,(WPARAM)CreateFontIndirect(&TheFont),MAKELPARAM(TRUE,0));
		SendMessage(EditBox,WM_SETFONT,(WPARAM)CreateFontIndirect(&TheFont),MAKELPARAM(TRUE,0));
	}
}
int CALLBACK ConnectProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
	int i;
	HMENU TheMenu;

	switch(message)
	{
	case WM_INITDIALOG:
		SendMessage(GetDlgItem(hWnd,IDC_CONHANDLE),WM_SETTEXT,0,(LPARAM)MyHandle);
		SendMessage(GetDlgItem(hWnd,IDC_CONSERVER),IPM_SETADDRESS,0,ConvertStrToIP((char *)nlAddrToString(&ServerAddr, TempStr)));
		SendMessage(GetDlgItem(hWnd,IDC_CONCLIENT),BM_SETCHECK,BST_CHECKED,0);
		SendMessage(GetDlgItem(hWnd,IDC_IPLIST),BM_SETIMAGE,IMAGE_ICON,(LPARAM)LoadIcon(GlobalInst,MAKEINTRESOURCE(IDI_IPLISTICON)));
		return TRUE;
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDOK:
			SendMessage(GetDlgItem(hWnd,IDC_CONHANDLE),WM_GETTEXT,256,(LPARAM)MyHandle);
			if(SendMessage(GetDlgItem(hWnd,IDC_CONSVR),BM_GETCHECK,0,0)&BST_CHECKED)
			{
				swscanf(ThePort,TEXT("%i"),&i);
				ServerSocket=nlOpen(i,NL_RELIABLE);
		
				if(ServerSocket==NL_INVALID)
					return -1;
				nlGetLocalAddr(ServerSocket, &ServerAddr);
				IsConnected=TRUE;
				UnicodeATS(&ServerAddr,ts2);
				swprintf(ts,_TEXT("HawkNL Chat:Server-%s"), ts2);
				SetWindowText(WindowHWND,ts);
				swprintf(ts,_TEXT("ChatServer IP is %s\r\n"), ts2);
				AddText(ts);
				nlListen(ServerSocket);
				SetTimer(WindowHWND,1,10,ServerTimer);
				IsServer=TRUE;
			}
			else
			{
				ServerSocket=nlOpen(0,NL_RELIABLE);
				GetWindowText(GetDlgItem(hWnd,IDC_CONSERVER),ts,255);
				wcscat(ts,_TEXT(":"));
				wcscat(ts,ThePort);
				
				UnicodeSTA(ts,&ServerAddr);
				nlConnect(ServerSocket,&ServerAddr);
				wcscpy(ts,_TEXT("@"));
				wcscat(ts,MyHandle);
				nlWrite(ServerSocket,ts,sizeof(ts));
				swprintf(ts,_TEXT("<%s> Connected.\r\n"),MyHandle);
				nlWrite(ServerSocket,ts,sizeof(ts));
				UnicodeATS(&ServerAddr,ts2);	
				swprintf(ts,_TEXT("Connecting to %s...\r\n"),ts2);
				AddText(ts);
				SetTimer(WindowHWND,1,10,ClientTimer);
				IsServer=FALSE;
			}
			SendMessage(hWnd,WM_DESTROY,0,0);
			return TRUE;
		case IDCANCEL:
			SendMessage(hWnd,WM_DESTROY,0,0);
			return TRUE;
		case IDC_CONSVR:
			EnableWindow(GetDlgItem(hWnd,IDC_CONSERVER),FALSE);
			return TRUE;
		case IDC_CONCLIENT:
			EnableWindow(GetDlgItem(hWnd,IDC_CONSERVER),TRUE);
			return TRUE;
		case IDC_CONFONT:
			ChangeChatFont();
			return TRUE;
		case IDC_IPLIST:
			TheMenu=CreatePopupMenu();
			for(i=0;i<NumIPs;i++)
			{
				NoPortAddr(IPs+i,ts);
				AppendMenu(TheMenu,MF_ENABLED|MF_STRING,ID_IPMENU+i,ts);
			}
			GetWindowRect(GetDlgItem(hWnd,IDC_IPLIST),&aRect);
			TrackPopupMenu(TheMenu,TPM_LEFTALIGN|TPM_TOPALIGN,aRect.right,aRect.top,0,hWnd,NULL);
			DestroyMenu(TheMenu);
			return TRUE;
		default:
			if(LOWORD(wParam)>=ID_IPMENU)
			{
				SendMessage(GetDlgItem(hWnd,IDC_CONSERVER),IPM_SETADDRESS,0,ConvertStrToIP((char *)nlAddrToString(IPs+LOWORD(wParam)-ID_IPMENU, TempStr)));
			}
			return TRUE;
		};
		return TRUE;
	case WM_DESTROY:
		EndDialog(hWnd,0);
		return TRUE;
	};
	return FALSE;
}
long PASCAL WindowProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
	WindowHWND=hWnd;
//	PAINTSTRUCT PaintSt;
//	HGDIOBJ TempBMP;
	int i;
	int j;
	switch(message)
	{
	case WM_CREATE:
		InitStuff(hWnd);
		return 0;
	case WM_SIZE:
		fWidth=LOWORD(lParam);
		fHeight=HIWORD(lParam);
		SetWindowPos(ChatBox,HWND_TOP,0,0,LOWORD(lParam)-200,HIWORD(lParam)-20,SWP_NOZORDER);
		SetWindowPos(EditBox,HWND_TOP,0,HIWORD(lParam)-20,LOWORD(lParam)-200,20,SWP_NOZORDER);
		SetWindowPos(HandleBox,HWND_TOP,LOWORD(lParam)-200,0,200,HIWORD(lParam),SWP_NOZORDER);
		return 0;
	case WM_COMMAND:
		switch((int)LOWORD(wParam))
		{
		case ID_CONNECT_CONNECT:
			ConnectHWND=CreateDialog(GlobalInst,MAKEINTRESOURCE(IDD_CONNECT),hWnd,ConnectProc);
			ShowWindow(ConnectHWND,SW_SHOWNORMAL);
			UpdateWindow(ConnectHWND);
			return 0;
		case ID_CONNECT_DISCONNECT:
			if(!IsConnected)
				return 0;
			SetWindowText(hWnd,TEXT("HawkNL Chat"));
			if(IsServer)
			{
				IsConnected=FALSE;
				nlClose(ServerSocket);
				for(i=0;i<NumClients;i++)
				{
					wcscpy(ts,_TEXT("Server Disconnected\r\n"));
					nlWrite(ClientSocket[i],ts,sizeof(ts));
					for(j=0;j<NumClients;j++)
					{
						swprintf(ts,_TEXT("#%s"),ClientHandles[j]);
						nlWrite(ClientSocket[i],ts,sizeof(ts));
					}
					nlClose(ClientSocket[i]);
				}
				AddText(_TEXT("Disconnected\r\n"));
				KillTimer(hWnd,1);
			}
			else
			{
				swprintf(ts,_TEXT("<%s> Disconnected\r\n"),MyHandle);
				nlWrite(ServerSocket,ts,sizeof(ts));
				swprintf(ts,_TEXT("$%s"),MyHandle);
				nlWrite(ServerSocket,ts,sizeof(ts));
				nlClose(ServerSocket);
				AddText(_TEXT("Disconnected.\r\n"));
				IsConnected=FALSE;
				KillTimer(hWnd,1);
			}
			SendMessage(HandleBox,LB_RESETCONTENT,0,0);
			return 0;
		case ID_OPTIONS_HANDLE:
			HandleHWND=CreateDialog(GlobalInst,MAKEINTRESOURCE(IDD_HANDLE),hWnd,HandleProc);
			ShowWindow(HandleHWND,SW_SHOWNORMAL);
			UpdateWindow(HandleHWND);
			return 0;
		case ID_OPTIONS_FONT:
			ChangeChatFont();
			return 0;
		case ID_OPTIONS_PORT:
			PortHWND=CreateDialog(GlobalInst,MAKEINTRESOURCE(IDD_PORTDLG),hWnd,PortProc);
			ShowWindow(PortHWND,SW_SHOWNORMAL);
			UpdateWindow(PortHWND);
			return 0;
		case ID_CONNECT_EXIT:
			SendMessage(hWnd,WM_COMMAND,MAKEWPARAM(ID_CONNECT_DISCONNECT,0),0);
			SendMessage(hWnd,WM_DESTROY,0,0);
			return 0;
		case ID_EDITBOX:
			if(HIWORD(wParam)==EN_CHANGE)
			{
				if(IsConnected)
				{
					SendMessage(EditBox,WM_GETTEXT,256,(LPARAM)ts);
					if(ts[wcslen(ts)-1]=='\n')
					{
						wcscpy(ts2,_TEXT("<"));
						wcscat(ts2,MyHandle);
						wcscat(ts2,_TEXT(">: "));
						wcscat(ts2,ts);
						AddText(ts2);
						if(IsServer)
						{
							for(i=0;i<NumClients;i++)
							{
								nlWrite(ClientSocket[i],ts2,sizeof(ts2));
							}
						}
						else
							nlWrite(ServerSocket,ts2,sizeof(ts2));
							
						SetWindowText(EditBox,_TEXT(""));
					}
				}
				else
				{
					SetWindowText(EditBox,_TEXT(""));
				}
			}
			return 0;
		}
		return 0;
	case WM_DESTROY:
		SaveINI();
		delete []IPs;
		delete []TextBuffer;
		delete []TempTextBuffer;
		nlShutdown();
		PostQuitMessage(0);
		return 0;
	default:
		return DefWindowProc(hWnd,message,wParam,lParam);
	}
}
void InitStuff(HWND hWnd)
{
	wcscpy(MyHandle,_TEXT("NoName Dude"));
	TextBuffer=new wchar_t[256*256];
	TempTextBuffer=new wchar_t[256*256];
	INITCOMMONCONTROLSEX ICCE;
	ICCE.dwSize=sizeof(INITCOMMONCONTROLSEX);
	ICCE.dwICC=ICC_WIN95_CLASSES|ICC_INTERNET_CLASSES;
	InitCommonControlsEx(&ICCE);
	nlInit();
	nlSelectNetwork(NL_IP);
	LoadINI();
	LoadLibrary(_TEXT("RichEd20.Dll"));
	EditBox=CreateWindowEx(NULL,_TEXT("EDIT"),_TEXT(""),WS_BORDER|WS_CHILD|WS_VISIBLE|ES_AUTOHSCROLL|ES_MULTILINE|ES_WANTRETURN|ES_AUTOVSCROLL,0,0,0,0,hWnd,(HMENU)ID_EDITBOX,GlobalInst,NULL);
	HandleBox=CreateWindowEx(NULL,_TEXT("LISTBOX"),_TEXT(""),WS_CHILD|WS_VISIBLE|LBS_DISABLENOSCROLL|LBS_NOINTEGRALHEIGHT|LBS_STANDARD,0,0,0,0,hWnd,(HMENU)ID_HANDLEBOX,GlobalInst,NULL);
	ChatBox=CreateWindowEx(NULL,RICHEDIT_CLASS,_TEXT(""),WS_BORDER|WS_CHILD|WS_VISIBLE|ES_READONLY|ES_MULTILINE|WS_VSCROLL|ES_AUTOVSCROLL,0,0,0,0,hWnd,(HMENU)ID_CHATBOX,GlobalInst,NULL);
	SendMessage(ChatBox,WM_SETFONT,(WPARAM)CreateFont(14,0,0,0,FW_NORMAL,FALSE,FALSE,FALSE,ANSI_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH|FF_DONTCARE,_TEXT("Arial")),0);
	SendMessage(HandleBox,WM_SETFONT,(WPARAM)CreateFont(14,0,0,0,FW_NORMAL,FALSE,FALSE,FALSE,ANSI_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH|FF_DONTCARE,_TEXT("Arial")),0);
	SendMessage(EditBox,WM_SETFONT,(WPARAM)CreateFont(14,0,0,0,FW_NORMAL,FALSE,FALSE,FALSE,ANSI_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH|FF_DONTCARE,_TEXT("Arial")),0);

}
