/* the EverQuest protocol is documented at
   http://everquest.station.sony.com/support/general/server_status_protocal.jsp*/

#include <stdio.h>
#include <stdlib.h>
#include "nl.h"

static void printErrorExit(void)
{
    NLenum err = nlGetError();

    if(err == NL_SOCKET_ERROR)
    {
        printf("System error: %s\n", nlGetSystemErrorStr(nlGetSystemError()));
    }
    else
    {
        printf("HawkNL error: %s\n", nlGetErrorStr(err));
    }
    nlShutdown();
    exit(EXIT_FAILURE);
}

int main(int argc, char **argv)
{
    NLsocket    sock;
    NLaddress   addr;
    NLbyte      server[] = "www.hawksoft.com";
    NLushort    port = 80;
    NLbyte      command[] = {0xFF, 0xFF, 0x09, 0x00};
    NLenum      type = NL_RELIABLE; /* TCP */

    if(!nlInit())
       return 1;
    if(!nlSelectNetwork(NL_IP))
    {
        nlShutdown();
        return 1;
    }
    nlEnable(NL_BLOCKING_IO);
    /* create server the address */
    nlGetAddrFromName(server, &addr);
    nlSetAddrPort(&addr, port);
    /* create the socket */
    sock = nlOpen(0, type);
    if(sock == NL_INVALID)
    {
        printErrorExit();
    }
    /* connect to the server */
    if(nlConnect(sock, &addr) == NL_FALSE)
	{
        printErrorExit();
	}
	nlClose(sock);

    /* create the socket */
    sock = nlOpen(0, type);
    if(sock == NL_INVALID)
    {
        printErrorExit();
    }
    /* connect to the server */
    if(nlConnect(sock, &addr) == NL_FALSE)
	{
        printErrorExit();
	}
	nlClose(sock);
	
    nlShutdown();
    return 0;
}

