/*
  Sample program for the HawkNL cross platform network library
  Copyright (C) 2000 Phil Frisbie, Jr. (phil@hawksoft.com)
*/
/*
  This app opens up UDP sockets until the system cannot open up any more,
  or it hits the NL_MAX_INT_SOCKETS limit. On a Windows NT 4.0 server with
  384 MB of RAM, it can open up 8192 UDP sockets (the max for NL), and
  Windows 95 can open up 252 UDP sockets.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "nl.h"

#if defined WIN32 || defined WIN64
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#define sleep(x)    Sleep((DWORD)(1000 * (x)))
#endif

static void printErrorExit(void)
{
    NLenum err = nlGetError();

    if(err == NL_SOCKET_ERROR)
    {
        printf("System error: %u, %s\n", (unsigned int)err, nlGetSystemErrorStr(nlGetSystemError()));
    }
    else
    {
        printf("HawkNL error: %s\n", nlGetErrorStr(err));
    }
    nlShutdown();
    exit(EXIT_FAILURE);
}


int main(int argc, char **argv)
{
    NLsocket    sock;
    NLaddress   address;

    if(nlInit() == NL_FALSE)
        printErrorExit();

    printf("nlGetString(NL_VERSION) = %s\n", nlGetString(NL_VERSION));
    printf("nlGetString(NL_NETWORK_TYPES) = %s\n", nlGetString(NL_NETWORK_TYPES));
    printf("nlGetInteger(NL_MAX_SOCKETS) = %d\n\n", nlGetInteger(NL_MAX_SOCKETS));

    if(nlSelectNetwork(NL_IP) == NL_FALSE)
        printErrorExit();


    while(1 == 1)
    {
        /* create a client socket */
        sock = nlOpen(0, NL_UNRELIABLE); /* let the system assign the port number */
        if(sock == NL_INVALID)
        {
            printf("\nFailed at %d sockets\n", nlGetInteger(NL_OPEN_SOCKETS));
            printErrorExit();
        }
        nlGetLocalAddr(sock, &address);
        printf("Socket: %d, port: %hu\r", sock, nlGetPortFromAddr(&address));
    }

    printf("\nOpened %d sockets\n", nlGetInteger(NL_OPEN_SOCKETS));
    nlShutdown();
    return 0;
}

