/*
  Sample program for the HawkNL cross platform network library
  Copyright (C) 2000 Phil Frisbie, Jr. (phil@hawksoft.com)
*/
/*
 This app tests the swap and read/write buffer macros
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if defined WIN32 || defined WIN64
#include <conio.h>
#endif
#include "nl.h"


static void printErrorExit(void)
{
    NLenum err = nlGetError();

    if(err == NL_SOCKET_ERROR)
    {
        printf("System error: %s\n", nlGetSystemErrorStr(nlGetSystemError()));
    }
    else
    {
        printf("HawkNL error: %s\n", nlGetErrorStr(err));
    }
    nlShutdown();
    exit(EXIT_FAILURE);
}

int main(int argc, char **argv)
{
    NLbyte      buffer[NL_MAX_STRING_LENGTH];
    NLint       count = 0;
    NLbyte      b = (NLbyte)99;
    NLushort    s = 0x1122;
    NLulong     l = 0x11223344;
    NLfloat     f = 12.3141592651f;
    NLdouble    d = 123.12345678901234;
    NLbyte      string[NL_MAX_STRING_LENGTH] = "Hello";
    NLbyte      block[] = {9,8,7,6,5,4,3,2,1,0};

    if(nlInit() == NL_FALSE)
        printErrorExit();

    printf("nlGetString(NL_VERSION) = %s\n\n", nlGetString(NL_VERSION));
    printf("nlGetString(NL_NETWORK_TYPES) = %s\n\n", nlGetString(NL_NETWORK_TYPES));

    if(nlSelectNetwork(NL_IP) == NL_FALSE)
        printErrorExit();

    printf("Short number: %#x, ", s);
    s = nlSwaps(s);
    printf("swapped: %#x, ", s);
    s = nlSwaps(s);
    printf("swapped back: %#x\n", s);

    printf("Long number: %#lx, ", l);
    l = nlSwapl(l);
    printf("swapped: %#lx, ", l);
    l = nlSwapl(l);
    printf("swapped back: %#lx\n", l);

    printf("Float number: %.10f, ", f);
    f = nlSwapf(f);
    printf("swapped: %.10f, ", f);
    f = nlSwapf(f);
    printf("swapped back: %.10f\n", f);

    printf("Double number: %.14f, ", d);
    d = nlSwapd(d);
    printf("swapped: %.24f, ", d);
    d = nlSwapd(d);
    printf("swapped back: %.14f\n", d);
    printf("\n");

    printf("write byte %d to buffer\n", b);
    printf("write short %#x to buffer\n", s);
    printf("write long %#lx to buffer\n", l);
    printf("write float %f to buffer\n", f);
    printf("write double %.14f to buffer\n", d);
    printf("write string %s to buffer\n", string);
    printf("write block %d%d%d%d%d%d%d%d%d%d to buffer\n", block[0]
            , block[1], block[2], block[3], block[4], block[5], block[6]
            , block[7], block[8], block[9]);
    printf("\n");
    writeByte(buffer, count, b);
    writeShort(buffer, count, s);
    writeLong(buffer, count, l);
    writeFloat(buffer, count, f);
    writeDouble(buffer, count, d);
    writeString(buffer, count, string);
    writeBlock(buffer, count, block, 10);

    /* reset count to zero to read from start of buffer */
    count = 0;

    readByte(buffer, count, b);
    readShort(buffer, count, s);
    readLong(buffer, count, l);
    readFloat(buffer, count, f);
    readDouble(buffer, count, d);
    readString(buffer, count, string);
    readBlock(buffer, count, block, 10);
    printf("read byte %d from buffer\n", b);
    printf("read short %#x from buffer\n", s);
    printf("read long %#lx from buffer\n", l);
    printf("read float %f from buffer\n", f);
    printf("read double %.14f from buffer\n", d);
    printf("read string %s from buffer\n", string);
    printf("read block %d%d%d%d%d%d%d%d%d%d from buffer\n", block[0]
            , block[1], block[2], block[3], block[4], block[5], block[6]
            , block[7], block[8], block[9]);

    nlShutdown();
#if defined WIN32 || defined WIN64
    /* this 'holds open' the DOS box so we can read the output */
    printf("\nHit any key");
    (void)_getch();
#endif
    return 0;
}

