#include "NetworkManager.h"
#include "globals.h"
#include "XPModel.h"
#include "Player.h"
#include "PlayerList.h"
#include "XPModelList.h"
#include "algebra.h"


extern XPModelList *xpModelList;
extern PlayerList *playerList;
extern XPModelList *projectileList;
extern unsigned char packet[MAXPACKETLEN];

NetworkManager::NetworkManager()
{
	sessiontoken = -1;
    nlInit();
	nlSelectNetwork(NL_IP);
	nlEnable(NL_BLOCKING_IO);
	nlEnable(NL_TCP_NO_DELAY);

	group = nlGroupCreate();
}

NetworkManager::~NetworkManager()
{
	if (sessiontoken != -1)
		doDisconnect();
	nlGroupDestroy(group);
	nlShutdown();
}

int NetworkManager::doConnect(char *servaddrport)
{
    NLaddress   addr;
    int i;

	if (sessiontoken != -1)
		doDisconnect();
    clientsock = nlOpen(0, NL_RELIABLE);
	NLenum err = nlGetError();
    if(clientsock == NL_INVALID)
        return -1;
    nlStringToAddr(servaddrport, &addr);
	if (addr.valid == NL_FALSE)
		return -1;
	if(!nlConnect(clientsock, &addr))
        return -1;
	sendCommand(HELLO);
	//connection established. recv hello and session token 
	unsigned char hello,cmd;
	int n = recvCommand(&hello);
	if (n != 1 || hello != HELLO)
	{
		nlClose(clientsock);
		clientsock = NL_INVALID;
		return -1;
	}
	recvCommand(&hello);
	sessiontoken = hello;

	nlGroupAddSocket(group, clientsock);

	//get the entire game state from the server when starting up
	//the later updates are differential
	recvCommand(&cmd);
	if(cmd!=GAMEWEAPONSTATE){
		doDisconnect();
		return -1;
	}
	recvCommand(&cmd);
	int pktlen=cmd*(3+4*3*sizeof(float));
	recvPacket(packet,pktlen);
	int cursor=0;
	unsigned char charTemp;
	XPModel *model;
	for(i=0;i<cmd;i++){
			
			//ModelId
			model=new XPModel();
			
			readByte(packet,cursor,charTemp);
			model->setID(charTemp);
			//ModelType
				
			readByte(packet,cursor,charTemp);
			model->setModelTypeIndex(charTemp);

			//ActiveFlag

			readByte(packet,cursor,charTemp);
			if(charTemp!=0){
				model->setActive(true);
			}
			else{
				model->setActive(false);
			}
			//Position

			vec3 vec;

			readFloat(packet,cursor,vec[0]);
			readFloat(packet,cursor,vec[1]);
			readFloat(packet,cursor,vec[2]);
			
			model->setPosition(vec3(vec[0],vec[1],vec[2]));
			//Orientation
			
			readFloat(packet,cursor,vec[0]);
			readFloat(packet,cursor,vec[1]);
			readFloat(packet,cursor,vec[2]);
			
			model->setOrientation(vec3(vec[0],vec[1],vec[2]));

			//Velocity

			readFloat(packet,cursor,vec[0]);
			readFloat(packet,cursor,vec[1]);
			readFloat(packet,cursor,vec[2]);

			model->setVelocity(vec3(vec[0],vec[1],vec[2]));

			//Acceleration

			readFloat(packet,cursor,vec[0]);
			readFloat(packet,cursor,vec[1]);
			readFloat(packet,cursor,vec[2]);

			model->setAcceleration(vec3(vec[0],vec[1],vec[2]));

			xpModelList->addModel(model);
	}

	//Now read Player state
	recvCommand(&cmd);
	if(cmd!=GAMEPLAYERSTATE){
		doDisconnect();
		return -1;
	}
	recvCommand(&cmd);
	pktlen=cmd*(2+sizeof(float)+3+2*3*sizeof(float));

	recvPacket(packet,pktlen);
	cursor = 0;
	Player *player;
	for(i=0;i<cmd;i++){


		//PlayerID
	
		readByte(packet,cursor,charTemp);
		float vec[3];
		player=new Player(charTemp);
		
		
		//MotionState
		
		readByte(packet,cursor,charTemp);

		player->setMotionState((MotionState)charTemp);
		
		//ModelType
		
		readByte(packet,cursor,charTemp);
		
		
		player->setModelTypeIndex(charTemp);
		
		
		//Position

		

		readFloat(packet,cursor,vec[0]);
		readFloat(packet,cursor,vec[1]);
		readFloat(packet,cursor,vec[2]);
		
		player->setPosition(vec3(vec[0],vec[1],vec[2]));
		//Orientation
		
		readFloat(packet,cursor,vec[0]);
		readFloat(packet,cursor,vec[1]);
		readFloat(packet,cursor,vec[2]);
		
		player->setOrientation(vec3(vec[0],vec[1],vec[2]));


		

		readByte(packet,cursor,charTemp);
		player->setAction(charTemp);

		readByte(packet,cursor,charTemp);
		player->setPreviousAction(charTemp);
		
		float aTime;
		readFloat(packet,cursor,aTime);
		player->setAnimationTime(aTime);

		playerList->addPlayer(player);
	}
	
//Read projectile State
	recvCommand(&cmd);
	if(cmd!=GAMEPROJECTILESTATE){
		doDisconnect();
		return -1;
	}
	recvCommand(&cmd);
	pktlen=cmd*(3+4*3*sizeof(float));
	recvPacket(packet,pktlen);
	
	for(i=0;i<cmd;i++){
			
			//Owner

			readByte(packet,cursor,charTemp);
			//ModelId
			model=new XPModel();
			model->setOwner(charTemp);
			
			readByte(packet,cursor,charTemp);
			model->setID(charTemp);
			//ModelType
				
			readByte(packet,cursor,charTemp);
			model->setModelTypeIndex(charTemp);

			
			//Position

			vec3 vec;

			readFloat(packet,cursor,vec[0]);
			readFloat(packet,cursor,vec[1]);
			readFloat(packet,cursor,vec[2]);
			
			model->setPosition(vec3(vec[0],vec[1],vec[2]));
			//Orientation
			
			readFloat(packet,cursor,vec[0]);
			readFloat(packet,cursor,vec[1]);
			readFloat(packet,cursor,vec[2]);
			
			model->setOrientation(vec3(vec[0],vec[1],vec[2]));

			//Velocity

			readFloat(packet,cursor,vec[0]);
			readFloat(packet,cursor,vec[1]);
			readFloat(packet,cursor,vec[2]);

			model->setVelocity(vec3(vec[0],vec[1],vec[2]));

			//Acceleration

			readFloat(packet,cursor,vec[0]);
			readFloat(packet,cursor,vec[1]);
			readFloat(packet,cursor,vec[2]);

			model->setAcceleration(vec3(vec[0],vec[1],vec[2]));

			projectileList->addModel(model);
	}


	return sessiontoken;
}

void NetworkManager::doDisconnect()
{ 
	sendCommand(BYE);
	sendCommand(sessiontoken);
	shutDown();
}

//severe form of disconnect
void NetworkManager::shutDown()
{
	nlGroupDeleteSocket(group, clientsock);
	nlClose(clientsock);
	sessiontoken = -1;
}

inline int NetworkManager::sendCommand(unsigned char cmd)
{
	return ((nlWrite(clientsock, &cmd, 1) != 1) ? -1 : 1);
}

int NetworkManager::recvCommand(unsigned char *cmd)
{
	return ((nlRead(clientsock, cmd, 1) != 1) ? -1 : 1);
}

int NetworkManager::asyncRecvCommand(unsigned char *cmd)
{
	int numactive;
	NLsocket activesocks[1];

	if ( (numactive = nlPollGroup(group, NL_READ_STATUS, activesocks, 1, 0)) <= 0)
		return numactive;
	return ((nlRead(clientsock, cmd, 1) != 1) ? -1 : 1);	
}

int NetworkManager::sendPacket(unsigned char *packet, int len)
{
	return (nlWrite(clientsock, packet, len));
}

int NetworkManager::recvPacket(unsigned char *packet, int packetlen)
{
	int n = 0, totalread = 0;
	
	while ( (n = nlRead(clientsock, (void *)(packet+totalread), packetlen - totalread)) > 0)
	{
		totalread += n;
		if (totalread == packetlen)
			return totalread;
	}
	if ( n < 0)
		return -1;
	return totalread;
}
