#ifndef _PLANEH_
#define _PLANEH_

#include "matrix.h"
#include "vec.h"
#include "Box.h"
#include "point.h"
#include "sphere.h"
#include "util.h"
#include "bsp.h"

typedef matrix<float> Matrix;

class Plane
{
public:

	Plane ();
	Plane (Matrix M);
	Plane (Matrix M, float d);
	Plane (vec3_t n, float d);
	Plane (plane_t p);

	float distance (float x, float y, float z);
	float distance (Point p);
	float distance (Sphere s);	

	void translate ( float dx, float dy, float dz );
	void translate ( float d );
	void rotateX (float alpha);
	void rotateY (float alpha);
	void rotateZ (float alpha);

	bool  collide (float x, float y, float z, float dx, float dy, float dz, float ln);
	float collideRatio (float x, float y, float z, float dx, float dy, float dz, float ln);
	
	void setNormal(Matrix M);
	void setNormal(vec3_t v);
	void setNormal(float dx, float dy, float dz);
	void setDist ( float d );

	Matrix getNormal();
	void   getNormal(vec3_t v);
	float  getDist() { return dist; }

	void print ();

private:
	vec3_t normal;
	float dist;
};


#endif
