#ifndef _HANDLERSH_
#define _HANDLERSH_

#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <math.h>

#ifndef SERVERCODE

#ifdef __cplusplus
extern "C"
{
#endif

#include <jconfig.h>
#include <jmorecfg.h>
#include <jpeglib.h>

#ifdef __cplusplus
}
#endif

#endif

#ifdef WIN32
#include "dirent.h"
#else
#include <dirent.h>
#endif

#include "glinc.h"
#include "globals.h"
#include "util.h"
#include "vec.h"
#include "bsp.h"

#ifndef SERVERCODE 
#endif //#ifdef  SERVERCODE
class BSPDataModel;

typedef struct
{
	int size[2];    /* Mesh dimensions, u&v */
	vec3_t *points;
	colour_t *colour;
	texcoord_t *tex_st;
	texcoord_t *lm_st;
	int numelems;
	uint_t *elems;
} mesh_t;

#define SHADERPASS_MAX 5
#define SHADER_ANIM_FRAMES_MAX 10

#define SHADERBUF_SIZE  (1024*1024-8)
#define MAX_NUM_TEXTURES 512
#define SHADER_ARGS_MAX (SHADER_ANIM_FRAMES_MAX+1)
#define LOWERCASE(c) ((c) <= 'Z' && (c) >= 'A' ? (c) + ('a'-'A') : (c))


	enum
	{
		SHADER_NOCULL        = 1 << 0,
		SHADER_TRANSPARENT   = 1 << 1,
		SHADER_DEPTHWRITE    = 1 << 2,  /* Also used for pass flag */
		SHADER_SKY           = 1 << 3,
		SHADER_NOMIPMAPS     = 1 << 4,
		SHADER_NEEDCOLOURS   = 1 << 5,
		SHADER_DEFORMVERTS   = 1 << 6
	};

	/* Shaderpass flags */
	enum
	{
		SHADER_LIGHTMAP   = 1 << 0,
		SHADER_BLEND      = 1 << 1,
		SHADER_ALPHAFUNC  = 1 << 3,
		SHADER_TCMOD      = 1 << 4,
		SHADER_ANIMMAP    = 1 << 5,
		SHADER_TCGEN_ENV  = 1 << 6
	};	

	/* Transform functions */
	enum
	{
		SHADER_FUNC_SIN             = 1,
		SHADER_FUNC_TRIANGLE        = 2,
		SHADER_FUNC_SQUARE          = 3,
		SHADER_FUNC_SAWTOOTH        = 4,
		SHADER_FUNC_INVERSESAWTOOTH = 5
	};

	/* *Gen functions */
	enum
	{
		SHADER_GEN_IDENTITY = 0,
		SHADER_GEN_WAVE     = 1,
		SHADER_GEN_VERTEX   = 2
	};

	/* tcmod functions */
	enum
	{
		SHADER_TCMOD_SCALE               = 1 << 1,
		SHADER_TCMOD_ROTATE              = 1 << 2,
		SHADER_TCMOD_SCROLL              = 1 << 3,
		SHADER_TCMOD_TRANSFORM           = 1 << 4,
		SHADER_TCMOD_TURB                = 1 << 5,
		SHADER_TCMOD_STRETCH             = 1 << 6,
	};


	/* Special texture loading requirements */
	enum
	{
		TEXFILE_NOMIPMAPS  = 1 << 0,
		TEXFILE_CLAMP      = 1 << 1
	};


/* Periodic functions */
typedef struct
{
	uint_t func;     /* SHADER_FUNC enum */
	float args[4];   /* offset, amplitude, phase_offset, rate */
} shaderfunc_t;
/* Per-pass rendering state information */

typedef struct
{
	uint_t flags;
	int texref;                 /* Texture ref (if not lightmap) */
	uint_t blendsrc, blenddst;  /* glBlend args */
	uint_t depthfunc;           /* glDepthFunc arg */
	uint_t alphafunc;           /* glAlphaFunc arg1 */
	float alphafuncref;         /* glAlphaFunc arg2 */
	uint_t rgbgen;              /* SHADER_GEN enum */
	shaderfunc_t rgbgen_func;
	uint_t tcmod;               /* SHADER_TCMOD enum */
	float tcmod_scale[2];       /* TCMOD args */
	float tcmod_rotate;
	float tcmod_scroll[2];
	float tcmod_transform[6];
	float tcmod_turb[4];
	shaderfunc_t tcmod_stretch;
	float anim_fps;             /* Animation frames per sec */
	int anim_numframes;
	int anim_frames[SHADER_ANIM_FRAMES_MAX];  /* Texture refs */
} shaderpass_t;


typedef struct
{
	uint_t flags;
	int numpasses;
	shaderpass_t pass[SHADERPASS_MAX];
	float skyheight;          /* Height for skybox */
	float deformv_wavesize;   /* DeformVertexes wavelength in world units */
	shaderfunc_t deformv_wavefunc;
} shader_t;


typedef struct
{
	char *keyword;
	int minargs, maxargs;
	void (* func)(BSPDataModel *bspDM, shader_t *shader, shaderpass_t *pass, int numargs, char **args);
} shaderkey_t;



//windows specific idiosyncs
#ifdef WIN32

#define O_RDONLY _O_RDONLY

#endif //win32

#define PATHLEN 256

#endif
