#include "XPModelList.h"
#include "XPModel.h"

void XPModelList::addModel(XPModel *model){
	
	modelVector.push_back(model);
	
}

void XPModelList::freeList(){
	std::vector<XPModel *>::iterator iter=modelVector.begin();
	while(iter != modelVector.end()){
		delete *iter;
		iter++;
	}
	modelVector.clear();
}

XPModel *XPModelList::getModel(int index){
	return modelVector[index];
}



int XPModelList::getLength(){
	return modelVector.size();
}

XPModelList::~XPModelList(){
	freeList();

}

XPModelList::XPModelList(){
}

void XPModelList::updatePosition(float increment){

	std::vector<XPModel *>::iterator iter=modelVector.begin();
	while(iter != modelVector.end()){
		/*
		vec3 randomDirection;
		randomDirection[0]=rand()*1.0/((float)RAND_MAX);
		randomDirection[1]=rand()*1.0/((float)RAND_MAX);
		randomDirection[2]=rand()*1.0/((float)RAND_MAX);

		(*iter)->setVelocity(randomDirection);
		*/
		(*iter)->moveAsOriented(increment);
		iter++;
	}

}

XPModel* XPModelList::removeModel(XPModel *model){
	XPModel *temp;
	std::vector<XPModel *>::iterator iter=modelVector.begin();
	while(iter != modelVector.end()){
		if(*iter==model){
				temp=(*iter);
				modelVector.erase(iter);
				return temp;
		}
		iter++;
	}
	return NULL;
}

XPModel* XPModelList::removeModel(int id){
	XPModel *temp;
	std::vector<XPModel *>::iterator iter=modelVector.begin();
	while(iter != modelVector.end()){
		if((*iter)->getID()==id){
				temp=(*iter);
				modelVector.erase(iter);
				return (temp);
		}
		iter++;
	}
	return NULL;
	
}

void XPModelList::setModel(int index,XPModel *model){
	modelVector[index]=model;
}

XPModel* XPModelList::removeModel(int owner,int id){
	std::vector<XPModel *>::iterator iter=modelVector.begin();
	XPModel *temp;
	while(iter != modelVector.end()){
		if(((*iter)->getID()==id)&&((*iter)->getOwner()==owner)){
				temp=(*iter);
				modelVector.erase(iter);
				return (temp);
		}
		iter++;
	}
	return NULL;
	
}
XPModel* XPModelList::getModel(int owner,int id){
	XPModel *temp;
	std::vector<XPModel *>::iterator iter=modelVector.begin();
	while(iter != modelVector.end()){
		if(((*iter)->getID()==id)&&((*iter)->getOwner()==owner)){
				temp=(*iter);
				
				return (temp);
		}
		iter++;
	}
	return NULL;
	
}
