#include "SoundObjectList.h"
#include "SoundObject.h"

#ifdef WIN32
#define PATHSTR "resources\\sounds\\"
#else
#define PATHSTR "resources/sounds/"
#endif

#ifdef WIN32
static const char *fileNames []={
"bass17.wav",
"pulse.wav",
"weapons\\noammo.wav",
"weapons\\machinegun\\machgf1b.wav",
"weapons\\machinegun\\ric2.wav",
"weapons\\shotgun\\sshotf1b.wav",
"weapons\\rocket\\rocklf1a.wav",
"weapons\\rocket\\rocklx1a.wav",
"misc\\am_pkup.wav",
"misc\\w_pkup.wav",
"player\\footsteps\\boot1.wav",
"player\\footsteps\\boot2.wav",
"player\\footsteps\\boot3.wav",
"player\\footsteps\\boot4.wav",
"world\\telein.wav",
"items\\n_health.wav",
"weapons\\change.wav",
"reload.wav",
"items\\protect.wav"
};
#else
static const char *fileNames []={
"bass17.wav",
"pulse.wav",
"weapons/noammo.wav",
"weapons/machinegun/machgf1b.wav",
"weapons/machinegun/ric2.wav",
"weapons/shotgun/sshotf1b.wav",
"weapons/rocket/rocklf1a.wav",
"weapons/rocket/rocklx1a.wav",
"misc/am_pkup.wav",
"misc/w_pkup.wav",
"player/footsteps/boot1.wav",
"player/footsteps/boot2.wav",
"player/footsteps/boot3.wav",
"player/footsteps/boot4.wav",
"world/telein.wav",
"items/n_health.wav",
"weapons/change.wav",
"reload.wav",
"items/protect.wav"
};
#endif

bool SoundObjectList::initList(){
	SoundObject *sound;
	bool success=true;

	char pathstr[256];
	strcpy(pathstr, PATHSTR);

	for(int i=0;i<( sizeof(fileNames)/sizeof(char *));i++){
		sound=new SoundObject;		
		if(!sound->loadWave(pathstr, fileNames[i])){
			printf ("error loading %s\n",fileNames[i]);
			success=false;
			freeList();
			break;
		}
		SoundObjectVector.push_back(sound);
	}
	return success;


}

void SoundObjectList::freeList(){
	std::vector<SoundObject *>::iterator iter=SoundObjectVector.begin();
	while(iter != SoundObjectVector.end()){
		delete *iter;
		iter++;
	}
	SoundObjectVector.clear();
}

SoundObject *SoundObjectList::getSound(int index){
	return SoundObjectVector[index];
}

int SoundObjectList::getLength(){
	return SoundObjectVector.size();
}

SoundObjectList::~SoundObjectList(){
	freeList();

}

SoundObjectList::SoundObjectList(){
}

SoundObject *SoundObjectList::getSound(const char* name){

	std::vector<SoundObject *>::iterator iter=SoundObjectVector.begin();
	while(iter != SoundObjectVector.end()){
		if(strcmp((*iter)->getTypeName(),name)==0){
			return *iter;
		}
		iter++;
	}

	return NULL;
}

int SoundObjectList::getIndex(const char *name){
	std::vector<SoundObject *>::iterator iter=SoundObjectVector.begin();
	int i=0;
	while(iter != SoundObjectVector.end()){
		if(strcmp((*iter)->getTypeName(),name)==0){
			return i;
		}
		iter++;
		i++;
	}

	return -1;
}
