#include <stdio.h>
#include <stdlib.h>
#include "SoundObject.h"


SoundObject::SoundObject()
{
	waveFile = NULL;
}

SoundObject::~SoundObject()
{
#ifdef SOUND_AV
	if (waveFile!=NULL)
		FSOUND_Sample_Free(waveFile);
#endif
}


bool SoundObject::loadWave(const char * path,const char *name)
{
#ifdef SOUND_AV
	char fileName[256];
	strcpy(fileName,path);
	strcat(fileName,name);
	return (loadWave (fileName));
#else
	return false;
#endif
}

bool SoundObject::loadWave (const char* filename)
{	
#ifdef SOUND_AV
	if (waveFile == NULL)
		waveFile = FSOUND_Sample_Load (FSOUND_UNMANAGED, filename, FSOUND_NORMAL, 0);
	else{
		FSOUND_Sample_Free(waveFile);
		waveFile = FSOUND_Sample_Load (FSOUND_UNMANAGED, filename, FSOUND_NORMAL, 0);
	}
	strcpy (typeName, filename);
	return (waveFile != NULL);
#else
	typeName[0] = 0;
	return false;
#endif
}

FSOUND_SAMPLE* SoundObject::getAudio()
{
	return waveFile;

}

const char* SoundObject::getTypeName(){
	return typeName;
}
