#ifndef _PLAYERH_
#define _PLAYERH_

#include <GL/glut.h>

#include <math.h>
#include "NetworkCommands.h"
#include "XPModel.h"
#include "XPModelList.h"
#include "Weapon.h"
#include "SoundObjectList.h"

class Player :public XPModel
{

protected:

	//Directions are unit vectors -1.0 to +1.0
	vec3 eyeOrientation;
	MotionState motionState;
	unsigned char playerID;
	float elevation;
	XPModelList myProjectiles;
	int health;
	
public:
	void lookDown(float increment);
	void lookUp(float increment);
	void turnRight(float increment);
	void turnLeft(float increment);
	vec3 getEyeOrientation();
	void setEyeOrientation(vec3 eye);
	void goDown(float increment);
	void goUp(float increment);
	void goLeft(float increment);
	void goRight(float increment);
	void goBack(float increment);
	void goForward(float increment);
	int getMotionState();
	void setMotionState(MotionState state);
	void updateState(float delta);
	Player();
	Player(int modelTypeIndex);
	bool fire();
	virtual ~Player();
	void setPlayerID(unsigned char id);
	unsigned char getPlayerID();
	bool sendUpdateToServer();
	void sendPickUpRequest(unsigned char modelID);
	void removeProjectile(XPModel *projectile);
	void updateProjectile(XPModel *projectile);
	void removeProjectile();
	void updateProjectile();
	void initWeapons();
	int getHealth();
	void setHealth(int hl);
	void changeHealth(int increment);
	

	Weapon weapons[3];
	int activeWeapon;
	int	haveGlasses;
	int haveMatrix;
	unsigned long matrixStartTime;
	int matrixOwner;


};

#endif
