#include "GUIManager.h"
#include "main.h"

//#define FULLSCREENMODE

#ifdef __cplusplus
extern "C"
{
#endif
	//generic display function
	void doNothing() {}
#ifdef __cplusplus
}
#endif

GUIManager::GUIManager(int argc, char **argv)
{
    glutInit(&argc, argv);
    glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);

#ifdef FULLSCREENMODE
	glutGameModeString( GAMEMODESTRING );
	glutEnterGameMode();
#else
    glutInitWindowSize(VIEWPORT_W, VIEWPORT_H);
    glutInitWindowPosition(50, 50);
    glutCreateWindow("The E X P E R I E N C E");
#endif

	//start off in the main menu
	curState = MAIN_MENU;
	mainmenu_init();
}

GUIManager::~GUIManager()
{

}

void GUIManager::setState(State newState)
{

	disableCallbacks();
	destroyOldState();

	curState = newState;
	switch(curState)
	{
	case MAIN_MENU:
		mainmenu_init();
		break;
	case MODEL_SELECTION:
		break;
	case MAP_SELECTION:
		break;
	case PLAY:
		play_init();
		break;
	case CONFIGURE:
		break;
	case HELP:
		break;
	case QUIT:
#ifdef FULLSCREENMODE
		glutLeaveGameMode();
#endif
		endGame();
		exit(0);
		break;
	default:
		break;
	}

}

void GUIManager::disableCallbacks()
{
    glutDisplayFunc(doNothing);
    glutIdleFunc(NULL);
    glutMouseFunc(NULL);
    glutMotionFunc(NULL);
	glutPassiveMotionFunc(NULL);
    glutKeyboardFunc(NULL);
    glutKeyboardUpFunc(NULL);
	glutSpecialFunc(NULL);
	glutSpecialUpFunc(NULL);
}

void GUIManager::destroyOldState()
{
	switch(curState)
	{
	case MAIN_MENU:
		mainmenu_finish();
		break;
	case MODEL_SELECTION:
		break;
	case MAP_SELECTION:
		break;
	case PLAY:
		play_finish();
		break;
	case CONFIGURE:
		break;
	case QUIT:
		break;
	default:
		break;
	}

}
