#include "Box.h"

Box::Box() 
{ 
	axes = Matrix (3,3);
	center = Matrix (3,1);
	size = Matrix (3,1);
	
	int i,j;
	for (i=0;i<3;i++){
		for (j=0;j<3;j++)
			axes(i,j) = (i==j);
		center (i,0) = 0.0;
		size (i,0) = 1.0;
	}	
}

Box::Box(int *c)
{
	axes = Matrix (3,3);
	center = Matrix (3,1);
	size = Matrix (3,1);
	
	int i,j;
	for (i=0;i<3;i++){
		for (j=0;j<3;j++)
			axes(i,j) = (i==j);
		center (i,0) = 0.5f*(c[i]+c[i+3]);
		size (i,0) = abs(c[i+3]-c[i]);
	}	
}

Box::Box(float *c)
{
	axes = Matrix (3,3);
	center = Matrix (3,1);
	size = Matrix (3,1);
	
	int i,j;
	for (i=0;i<3;i++){
		for (j=0;j<3;j++)
			axes(i,j) = (i==j);
		center (i,0) = 0.5f*(c[i]+c[i+3]);
		size (i,0) = fabs(c[i+3]-c[i]);
	}	
}


void Box::setAxes(Matrix M) { axes = M; }

void Box::setCenter(Matrix M) { center = M; }

void Box::setCenter ( float x, float y, float z )
{
	center(0,0) = x;
	center(1,0) = y;
	center(2,0) = z;
}

void Box::setSize(Matrix M) { size = M; } 	

void Box::setSize ( float x, float y, float z )
{
	size(0,0) = x;
	size(1,0) = y;
	size(2,0) = z;
}


Matrix Box::getAxes() { return axes; }

Matrix Box::getCenter() { return center; }

Matrix Box::getSize() { return size; }

Matrix Box::getExtent() { return size*(float)(.5); }

void Box::translate ( float dx, float dy, float dz )
{
	center(0,0) += dx;
	center(1,0) += dy;
	center(2,0) += dz;
}

void Box::rotateX (float alpha)
{
	for (int i=0;i<3;i++){
		for (int j=0;j<3;j++)
			box_rot(i,j) = (i==j);
	}
	box_rot (1,1) = cos(alpha);
	box_rot (1,2) = -sin(alpha);
	box_rot (2,1) = -box_rot(1,2);
	box_rot (2,2) = box_rot(1,1);

	axes = (box_rot*axes);
}

void Box::rotateY (float alpha)
{
	for (int i=0;i<3;i++){
		for (int j=0;j<3;j++)
			box_rot(i,j) = (i==j);
	}
	box_rot (0,0) = cos(alpha);
	box_rot (0,2) = -sin(alpha);
	box_rot (2,0) = -box_rot(0,2);
	box_rot (2,2) = box_rot(0,0);

	axes = (box_rot*axes);
}

void Box::rotateZ (float alpha)
{
	for (int i=0;i<3;i++){
		for (int j=0;j<3;j++)
			box_rot(i,j) = (i==j);
	}
	box_rot (0,0) = cos(alpha);
	box_rot (0,1) = -sin(alpha);
	box_rot (1,0) = -box_rot(0,1);
	box_rot (1,1) = box_rot(0,0);

	axes = (box_rot*axes);
}

void Box::scale (float s)
{
	for (int i=0;i<3;i++){
		size(i,0) *= s;
		center(i,0) *= s;
	}
}
	

void Box::transform (Transform T)
{
	axes = T.getRotation() * axes;
	center = T.getTranslation() + center;
}

void Box::transform (Matrix M)
{	
	transform(Transform(M));
}



void Box::printSimple()
{
	int i;
	//printf ("Min (");
	for (i=0;i<3;i++){		
		printf ("%4.3f",  center(i,0)-size(i,0)*.5 ); 
		if (i<2) printf (",");
	}
	//printf (") Max (");
	for (i=0;i<3;i++){		
		printf ("%4.3f",  center(i,0)+size(i,0)*.5 ); 
		if (i<2) printf (",");
		
	}	
	//printf (")\n");
}



bool Box::collide (Box b)
{
    // convenience variables
    akA = axes;
    akB = b.axes;
    afEA = size*(float).5;;
    afEB = b.size*(float).5;

    // compute difference of Box centers, D = C1-C0
    kD = center - b.center;

    float fR0, fR1, fR;   // interval radii and distance between centers
    float fR01;           // = R0 + R1

	int i,j;
    
	aafC = ~akA * akB;
	for (i=0;i<3;i++)
		for (j=0;j<3;j++)
			aafAbsC(i,j) = fabs(aafC(i,j));
	afAD = ~akA * kD;
	afBD = ~akB * kD;

    // axis C0+t*A0
    fR = fabs(afAD(0,0));
    fR1 = afEB(0,0)*aafAbsC(0,0)+afEB(1,0)*aafAbsC(0,1)+afEB(2,0)*aafAbsC(0,2);
    fR01 = afEA(0,0) + fR1;
    if ( fR > fR01 )
        return false;

    // axis C0+t*A1
    fR = fabs(afAD(1,0));
    fR1 = afEB(0,0)*aafAbsC(1,0)+afEB(1,0)*aafAbsC(1,1)+afEB(2,0)*aafAbsC(1,2);
    fR01 = afEA(1,0) + fR1;
    if ( fR > fR01 )
        return false;

    // axis C0+t*A2
    fR = fabs(afAD(2,0));
    fR1 = afEB(0,0)*aafAbsC(2,0)+afEB(1,0)*aafAbsC(2,1)+afEB(2,0)*aafAbsC(2,2);    
    fR01 = afEA(2,0) + fR1;
    if ( fR > fR01 )
        return false;

	
    // axis C0+t*B0
    fR = fabs(afBD(0,0));
    fR0 = afEA(0,0)*aafAbsC(0,0)+afEA(1,0)*aafAbsC(1,0)+afEA(2,0)*aafAbsC(2,0);
    fR01 = fR0 + afEB(0,0);
    if ( fR > fR01 )
        return false;

    // axis C0+t*B1
    fR = fabs(afBD(1,0));
    fR0 = afEA(0,0)*aafAbsC(0,1)+afEA(1,0)*aafAbsC(1,1)+afEA(2,0)*aafAbsC(2,1);
    fR01 = fR0 + afEB(1,0);
    if ( fR > fR01 )
        return false;

    // axis C0+t*B2
    fR = fabs(afBD(2,0));
    fR0 = afEA(0,0)*aafAbsC(0,2)+afEA(1,0)*aafAbsC(1,2)+afEA(2,0)*aafAbsC(2,2);
    fR01 = fR0 + afEB(2,0);
    if ( fR > fR01 )
        return false;

    // axis C0+t*A0xB0
    fR = fabs(afAD(2,0)*aafC(1,0)-afAD(1,0)*aafC(2,0));
    fR0 = afEA(1,0)*aafAbsC(2,0) + afEA(2,0)*aafAbsC(1,0);
    fR1 = afEB(1,0)*aafAbsC(0,2) + afEB(2,0)*aafAbsC(0,1);
    fR01 = fR0 + fR1;
    if ( fR > fR01 )
        return false;

    // axis C0+t*A0xB1
    fR = fabs(afAD(2,0)*aafC(1,1)-afAD(1,0)*aafC(2,1));
    fR0 = afEA(1,0)*aafAbsC(2,1) + afEA(2,0)*aafAbsC(1,1);
    fR1 = afEB(0,0)*aafAbsC(0,2) + afEB(2,0)*aafAbsC(0,0);
    fR01 = fR0 + fR1;
    if ( fR > fR01 )
        return false;

    // axis C0+t*A0xB2
    fR = fabs(afAD(2,0)*aafC(1,2)-afAD(1,0)*aafC(2,2));
    fR0 = afEA(1,0)*aafAbsC(2,2) + afEA(2,0)*aafAbsC(1,2);
    fR1 = afEB(0,0)*aafAbsC(0,1) + afEB(1,0)*aafAbsC(0,0);
    fR01 = fR0 + fR1;
    if ( fR > fR01 )
        return false;

    // axis C0+t*A1xB0
    fR = fabs(afAD(0,0)*aafC(2,0)-afAD(2,0)*aafC(0,0));
    fR0 = afEA(0,0)*aafAbsC(2,0) + afEA(2,0)*aafAbsC(0,0);
    fR1 = afEB(1,0)*aafAbsC(1,2) + afEB(2,0)*aafAbsC(1,1);
    fR01 = fR0 + fR1;
    if ( fR > fR01 )
        return false;

    // axis C0+t*A1xB1
    fR = fabs(afAD(0,0)*aafC(2,1)-afAD(2,0)*aafC(0,1));
    fR0 = afEA(0,0)*aafAbsC(2,1) + afEA(2,0)*aafAbsC(0,1);
    fR1 = afEB(0,0)*aafAbsC(1,2) + afEB(2,0)*aafAbsC(1,0);
    fR01 = fR0 + fR1;
    if ( fR > fR01 )
        return false;

    // axis C0+t*A1xB2
    fR = fabs(afAD(0,0)*aafC(2,2)-afAD(2,0)*aafC(0,2));
    fR0 = afEA(0,0)*aafAbsC(2,2) + afEA(2,0)*aafAbsC(0,2);
    fR1 = afEB(0,0)*aafAbsC(1,1) + afEB(1,0)*aafAbsC(1,0);
    fR01 = fR0 + fR1;
    if ( fR > fR01 )
        return false;

    // axis C0+t*A2xB0
    fR = fabs(afAD(1,0)*aafC(0,0)-afAD(0,0)*aafC(1,0));
    fR0 = afEA(0,0)*aafAbsC(1,0) + afEA(1,0)*aafAbsC(0,0);
    fR1 = afEB(1,0)*aafAbsC(2,2) + afEB(2,0)*aafAbsC(2,1);
    fR01 = fR0 + fR1;
    if ( fR > fR01 )
        return false;

    // axis C0+t*A2xB1
    fR = fabs(afAD(1,0)*aafC(0,1)-afAD(0,0)*aafC(1,1));
    fR0 = afEA(0,0)*aafAbsC(1,1) + afEA(1,0)*aafAbsC(0,1);
    fR1 = afEB(0,0)*aafAbsC(2,2) + afEB(2,0)*aafAbsC(2,0);
    fR01 = fR0 + fR1;
    if ( fR > fR01 )
        return false;

    // axis C0+t*A2xB2
    fR = fabs(afAD(1,0)*aafC(0,2)-afAD(0,0)*aafC(1,2));
    fR0 = afEA(0,0)*aafAbsC(1,2) + afEA(1,0)*aafAbsC(0,2);
    fR1 = afEB(0,0)*aafAbsC(2,1) + afEB(1,0)*aafAbsC(2,0);
    fR01 = fR0 + fR1;
    if ( fR > fR01 )
        return false;

    return true;
}

bool Box::collide (Sphere s)
{	
	box_mx = center + size * 0.5f;
	box_ml = center - size * 0.5f;
	box_O  = s.getPosition();
	box_Ob = center;
	box_O = (~axes * (box_O-box_Ob)) + box_Ob;
	float rad = s.getRadius();

	float dist = 0.0f;
	for (int i=0; i<3; i++){
		if (box_O(i,0) < box_ml(i,0)){
			float d = box_O(i,0) - box_ml(i,0);
			dist += d*d;
		}
		else if (box_O(i,0) > box_mx(i,0)){
			float d = box_O(i,0) - box_mx (i,0);
			dist += d*d;
		}
	}
	return (dist <= rad*rad);
}
	
bool Box::collide (Point p)
{
	box_mx = center + size * 0.5f;
	box_ml = center - size * 0.5f;
	box_O  = p.getPosition();
	box_Ob = center;
	box_O = (~axes * (box_O-box_Ob)) + box_Ob;
	
	float dist = 0.0f;
	for (int i=0; i<3; i++){
		if (box_O(i,0) < box_ml(i,0)){
			float d = box_O(i,0) - box_ml(i,0);
			dist += d*d;
		}
		else if (box_O(i,0) > box_mx(i,0)){
			float d = box_O(i,0) - box_mx (i,0);
			dist += d*d;
		}
	}
	return (dist <= 0);
}

bool Box::collide (float x, float y, float z)
{
	box_mx = center + size * 0.5f;
	box_ml = center - size * 0.5f;
	box_Ob = center;
	box_O (0,0) = x;
	box_O (1,0) = y;
	box_O (2,0) = z;	
	box_O = (~axes * (box_O-box_Ob)) + box_Ob;
	
	float dist = 0.0f;
	for (int i=0; i<3; i++){
		if (box_O(i,0) < box_ml(i,0)){
			float d = box_O(i,0) - box_ml(i,0);
			dist += d*d;
		}
		else if (box_O(i,0) > box_mx(i,0)){
			float d = box_O(i,0) - box_mx (i,0);
			dist += d*d;
		}
	}
	return (dist <= 0);
}

bool Box::collide ( float x, float y, float z, float dx, float dy, float dz, float ln)
{	
	
	segdir[0] = 0.5*ln*dx; 	segdir[1] = 0.5*ln*dy; 	segdir[2] = 0.5*ln*dz;
	seg_center[0] = x+segdir[0]; seg_center[1] = y+segdir[1]; seg_center[2] = z+segdir[2];
	box_mx = size * 0.5f;

	diff[0] = seg_center[0] - center(0,0); 	diff[1] = seg_center[1] - center(1,0); 	diff[2] = seg_center[2] - center(2,0);

	int i;
	for (i=0;i<3;i++){
		abs_segdir[i] = fabs(segdir[i]);
		abs_diff[i] = fabs(diff[i]);		
		if (abs_diff[i] > box_mx(i,0) + abs_segdir[i]) return false;
	}
	vec3_t cross;
	vec_cross (segdir,diff,cross);
	int idx[] = {0,1,2,0,1};
	int i1,i2;
	for (i=0;i<3;i++){
		i1 = idx[i+1]; i2=idx[i+2];
		abs_cross[i] = fabs(cross[i]);
		if (abs_cross[i] > box_mx(i1,0)*abs_segdir[i2] + box_mx(i2,0)*abs_segdir[i1]) return false;
	}	
	
	return true;	
}



/*
bool Box::collide ( float x, float y, float z, float dx, float dy, float dz)
{		
	segdir[0] = dx; segdir[1] = 0.5*ln*dy; 	segdir[2] = 0.5*ln*dz;
	_box_mx = size*.5;

	float f;
	diff[0] = x - center(0,0); 	diff[1] = y - center(1,0); 	diff[2] = z - center(2,0);

	int i;
	for (i=0;i<3;i++){
		abs_segdir[i] = fabs(segdir[i]);
		abs_diff[i] = fabs(diff[i]);		
		if (abs_diff[i] > _box_mx(i,0) + abs_segdir[i]) return false;
	}
	vec3_t cross;
	vec_cross (segdir,diff,cross);
	int idx[] = {0,1,2,0,1};
	int i1,i2;
	for (i=0;i<3;i++){
		i1 = idx[i+1]; i2=idx[i+2];
		abs_cross[i] = fabs(cross[i]);
		if (abs_cross[i] > _box_mx(i1,0)*abs_segdir[i2] + _box_mx(i2,0)*abs_segdir[i1]) return false;
	}
	
	return true;	
}
*/
// code to copy in
/*	
    Vector3D abs_segdir, abs_cross;
    float f;
    Vector3D diff = O - getCenter();

    for(int i=0;i<3;i++)
    {
      abs_segdir[i] = flabs(D[i]);
      if ( flabs(diff[i])>m_Size[i] && diff[i]*D[i]>=0.0f )
        return false;
    }

    Vector3D cross = CrossProduct(D,diff);

    abs_cross[0] = flabs(cross[0]);
    f = m_Size[1]*abs_segdir[2] + m_Size[2]*abs_segdir[1];
    if ( abs_cross[0] > f )
        return false;

    abs_cross[1] = flabs(cross[1]);
    f = m_Size[0]*abs_segdir[2] + m_Size[2]*abs_segdir[0];
    if ( abs_cross[1] > f )
        return false;

    abs_cross[2] = flabs(cross[2]);
    f = m_Size[0]*abs_segdir[1] + m_Size[1]*abs_segdir[0];
    if ( abs_cross[2] > f )
        return false;

    return true;
*/

