#ifndef _SPHEREH_
#define _SPHEREH_

#include "matrix.h"
#include "vec.h"
#include "point.h"

typedef matrix<float> Matrix;

class Sphere
{
public:
	Sphere ();
	Sphere (float x, float y, float z, float radius);
	Sphere (Matrix M, float radius);
	Sphere (vec3_t, float radius);

	float distance (float x, float y, float z);	
	float distance (Sphere s);
	float distance (Point p);

	void translate ( float dx, float dy, float dz );

	void setPosition ( float x, float y, float z );
	void setPosition ( Matrix M );
	void setPosition ( vec3_t v );
	void setRadius ( float r );
	
	Matrix getPosition();
	void   getPosition(vec3_t v );
	float  getRadius();

	void print();

private:
	float px,py,pz;
	float rad;
};

#endif