#include "sphere.h"

Sphere::Sphere ()
{
	px = py = pz = rad = 0;
}

Sphere::Sphere (float x, float y, float z, float r)
{
	px = x; py = y; pz = z;
	rad = r;
}

Sphere::Sphere (Matrix M, float r)
{
	px = M (0,0);
	py = M (1,0);
	pz = M (2,0);
	rad = r;
}

Sphere::Sphere (vec3_t v, float r)
{
	px = v[0];
	py = v[1];
	pz = v[2];
	rad = r;
}

float Sphere::distance (float x, float y, float z)
{
	return (sqrt((x-px)*(x-px)+(y-py)*(y-py)+(z-pz)*(z-pz)));
}

float Sphere::distance (Sphere s)
{
	return (sqrt((s.px-px)*(s.px-px)+(s.py-py)*(s.py-py)+(s.pz-pz)*(s.pz-pz)));
}

float Sphere::distance (Point p)
{
	vec3_t v;
	p.getPosition(v);
	return (sqrt((v[0]-px)*(v[0]-px)+(v[1]-py)*(v[1]-py)+(v[2]-pz)*(v[2]-pz)));
}

void Sphere::translate ( float dx, float dy, float dz )
{
	px += dx;
	py += dy;
	pz += dz;
}

void Sphere::setPosition ( float x, float y, float z )
{
	px = x;
	py = y;
	pz = z;
}

void Sphere::setPosition ( Matrix M )
{
	px = M(0,0);
	py = M(1,0);
	pz = M(2,0);
}

void Sphere::setPosition ( vec3_t v )
{
	px = v[0];
	py = v[1];
	pz = v[2];
}

void Sphere::setRadius ( float r )
{
	rad = r;
}
	
Matrix Sphere::getPosition()
{
	Matrix M(3,1);
	M(0,0) = px;
	M(1,0) = py;
	M(2,0) = pz;
	return M;
}

void Sphere::getPosition ( vec3_t v )
{
	v[0] = px;
	v[1] = py;
	v[2] = pz;
}


float Sphere::getRadius()
{
	return rad;
}

void Sphere::print()
{
	printf ("pos: %4.4f %4.4f %4.4f   rad: %4.4f\n",px,py,pz,rad);
}

