#include "ppmPictureList.h"

#ifdef WIN32
#define PATHSTR "resources\\images\\"
#else
#define PATHSTR "resources/images/"
#endif

#ifdef WIN32
static const char *fileNames []={
"hud\\char0.ppm", "hud\\char1.ppm", "hud\\char2.ppm", "hud\\char3.ppm", "hud\\char4.ppm", "hud\\char5.ppm",
"hud\\char6.ppm", "hud\\char7.ppm", "hud\\char8.ppm", "hud\\char9.ppm", "hud\\p_aug.ppm", "hud\\p_deagle.ppm",
"hud\\p_elite.ppm", "hud\\p_hegrenade.ppm", "hud\\p_knife.ppm", "hud\\p_m249.ppm", "hud\\p_m3.ppm",
"hud\\p_mac10.ppm", "hud\\p_scout.ppm", "hud\\hud_ammo.ppm", "hud\\hud_life.ppm","hud\\sglass.ppm","hud\\rocketl.ppm",
"hud\\hglass.ppm", "hud\\crosshair.ppm"
};
#else
static const char *fileNames []={
"hud/char0.ppm", "hud/char1.ppm", "hud/char2.ppm", "hud/char3.ppm", "hud/char4.ppm", "hud/char5.ppm",
"hud/char6.ppm", "hud/char7.ppm", "hud/char8.ppm", "hud/char9.ppm", "hud/p_aug.ppm", "hud/p_deagle.ppm",
"hud/p_elite.ppm", "hud/p_hegrenade.ppm", "hud/p_knife.ppm", "hud/p_m249.ppm", "hud/p_m3.ppm",
"hud/p_mac10.ppm", "hud/p_scout.ppm", "hud/hud_ammo.ppm", "hud/hud_life.ppm","hud/sglass.ppm","hud/rocketl.ppm",
"hud/hglass.ppm", "hud/crosshair.ppm"
};
#endif

bool ppmPictureList::initList(){
	ppmPicture *picture;
	bool success=true;

	char pathstr[256];
	strcpy(pathstr, PATHSTR);

	for(int i=0;i<( sizeof(fileNames)/sizeof(char *));i++){
		picture=new ppmPicture;		
		if(!picture->load(pathstr, fileNames[i])){
			success=false;
			freeList();
			break;
		}
		picture->calculateAlphaThreshold(10);
		ppmPictureVector.push_back(picture);
	}
	return success;


}

void ppmPictureList::freeList(){
	std::vector<ppmPicture *>::iterator iter=ppmPictureVector.begin();
	while(iter != ppmPictureVector.end()){
		delete *iter;
		iter++;
	}
	ppmPictureVector.clear();
}

ppmPicture *ppmPictureList::getPicture(int index){
	return ppmPictureVector[index];
}

int ppmPictureList::getLength(){
	return ppmPictureVector.size();
}

ppmPictureList::~ppmPictureList(){
	freeList();

}

ppmPictureList::ppmPictureList(){
}

ppmPicture *ppmPictureList::getPicture(const char* name){

	std::vector<ppmPicture *>::iterator iter=ppmPictureVector.begin();
	while(iter != ppmPictureVector.end()){
		if(strcmp((*iter)->getTypeName(),name)==0){
			return *iter;
		}
		iter++;
	}

	return NULL;
}

int ppmPictureList::getIndex(const char *name){
	std::vector<ppmPicture *>::iterator iter=ppmPictureVector.begin();
	int i=0;
	while(iter != ppmPictureVector.end()){
		if(strcmp((*iter)->getTypeName(),name)==0){
			return i;
		}
		iter++;
		i++;
	}

	return -1;
}
