#include "point.h"


Point::Point ()
{
	px = py = pz = 0;
}

Point::Point (float x, float y, float z)
{
	px = x;
	py = y;
	pz = z;
}

Point::Point (Matrix M)
{
	px = M(0,0);
	py = M(1,0);
	pz = M(2,0);
}

Point::Point (vec3_t v)
{
	px = v[0];
	py = v[1];
	pz = v[2];
}

float Point::distance (float x, float y, float z)
{
	return sqrt((x-px)*(x-px)+(y-py)*(y-py)+(z-pz)*(z-pz));
}

float Point::distance (Point p)
{
	return sqrt((p.px-px)*(p.px-px)+(p.py-py)*(p.py-py)+(p.pz-pz)*(p.pz-pz));
}

/*
float Point::distance (Plane p)
{
	return p.distance(*this);
}

float Point::distance (Sphere s)
{
	return 0;
}
*/

void Point::translate ( float dx, float dy, float dz )
{
	px += dx;
	py += dy;
	pz += dz;
}

void Point::setPosition ( float x, float y, float z )
{
	px = x;
	py = y;
	pz = z;
}

void Point::setPosition ( Matrix M )
{
	px = M(0,0);
	py = M(1,0);
	pz = M(2,0);
}

void Point::setPosition ( vec3_t v )
{
	px = v[0];
	py = v[1];
	pz = v[2];
}

Matrix Point::getPosition()
{
	Matrix M(3,1);
	M(0,0) = px;
	M(1,0) = py;
	M(2,0) = pz;
	return M;
}

void Point::getPosition(vec3_t v)
{
	v[0] = px;
	v[1] = py;
	v[2] = pz;
}


