#ifndef _RENDERENGINEH_
#define _RENDERENGINEH_

#include "handlers.h"

#include "Box.h"
#include "sphere.h"
#include "plane.h"
#include "point.h"

#include "Particle.h"

class ModelTypeList;
class Player;
class PlayerList;
class BasicGraphicList;
class GraphicModel;
class BSPDataModel;
class XPModelList;
class XPModel;
class ppmPictureList;

extern 	Player *viewer;
extern 	PlayerList *playerList;
extern 	ModelTypeList *modelTypeList;
extern	BasicGraphicList *basicGraphicList;
extern	XPModelList *xpModelList;
extern ppmPictureList *pictureList;

#define AZ_SCALE 0.3
#define EL_SCALE 0.3
#define MOVE_SPEED 300
#define GRAVITY 800
#define JUMP_SPEED 300

#define MATRIXMODETIMEDIFF 50 // in ms

#define RENDER_BSP_TESTVIS(from,to)  (*(bspDataModel->r_visibility->data + (from)*(bspDataModel->r_visibility->rowsize) + ((to)>>3)) & (1 << ((to) & 7)))


#define MAX_TRANSPARENT 1000

enum
{
    CLIP_RIGHT_BIT   = 1,
    CLIP_LEFT_BIT    = 1 << 1,
    CLIP_TOP_BIT     = 1 << 2,
    CLIP_BOTTOM_BIT  = 1 << 3,
    CLIP_FAR_BIT     = 1 << 4,
    CLIP_NEAR_BIT    = 1 << 5
};


/* rendering backend */
/* Preferentially sort by shader number, then lightmap */
/* FIXME: other things that could go in the sort key include transparency
 * and 'sort' directives from the shader scripts */
#define SORTKEY(face)  (((face)->shader << 16) + (face)->lm_texnum+1)

/* The back-end of the rendering pipeline does the actual drawing.
 * All triangles which share a rendering state (shader) are pushed together
 * into the 'arrays' structure.  This includes verts, texcoords, and element
 * numbers.  The renderer is then 'flushed': the rendering state is set
 * and the triangles are drawn.  The arrays and rendering state is then
 * cleared for the next set of triangles.
 */

/* FIXME: The manner in which faces are "pushed" to the arrays is really
   absimal.  I'm sure it could be highly optimized. */
/* FIXME: It would be nice to have a consistent view of faces, meshes,
   mapents, etc. so we don't have to have a "push" function for each. */

#define TWOPI 6.28318530718
#define TURB_SCALE 0.2

	typedef struct
	{
		int face;
		uint_t sortkey;
	} rendface_t;

	/* List of faces to render */
	typedef struct
	{
		int numfaces;
		rendface_t *faces;
	} facelist_t;

/* end of rendering backend */

class RenderEngine
{
private:
	vec3_t r_eyepos;      /* World coords */
	vec3_t r_eyedir;      /* Camera direction unit vector */
	float r_eye_az, r_eye_el;  /* eyedir azimuth and elevation (deg) */
	float r_eyefov;       /* Field of view angle (deg) */
	int r_eyecluster;     /* Current PVS cluster */
	int r_lockpvs;        /* Enable to lock PVS cluster */
	double g_frametime;   /* Current time */

	mat4_t clipmat;        /* Matrix to go from worldspace to clipspace */
	facelist_t facelist;   /* Faces to be drawn */
	facelist_t translist;  /* Transparent faces to be drawn */
	int r_leafcount;       /* Counts up leafs walked for this scene */
	int *r_faceinc;        /* Flags faces as "included" in the facelist */
	int *skylist;          /* Sky faces hit by walk */
	int numsky;            /* Number of sky faces in list */
	float cos_fov;         /* Cosine of the field of view angle */

	BSPDataModel *bspDataModel;

	double fpstime;
	int fpsframes;

	//helpers
	void render_walk_model(int n);
	int classify_point(vec3_t p, int plane_n);
	void render_walk_node(int n, int accept);
	void render_walk_leaf(int n, int accept);
	void render_walk_face(int n);
	void gen_clipmat(void);
	int cliptest_point(vec4_t p);
	int cliptest_bbox(bbox_t bbox);
	int cliptest_bboxf(bboxf_t bbox);
	int find_cluster(vec3_t pos);
	void sort_faces(void);

	/* rendering backend */

	void render_backend_init();
	void render_backend_finalize();
	void render_backend(facelist_t *list);
	void render_backend_sky(int numsky, int *skylist);
	//void render_backend_mapent(int mapent);
	//helpers
	/* Triangle arrays */
	typedef struct
	{
		int numverts;
		vec4_t *verts;
		colour_t *colour;
		texcoord_t *tex_st;
		texcoord_t *lm_st;
		int numelems;
		int *elems;
	} arrays_t;

	void render_pushface(face_t *face);
	void render_pushmesh(mesh_t *mesh);
	void render_stripmine(int numelems, int *elems);
	void render_flush(int shader, int lmtex);
	double render_func_eval(uint_t func, float *args);
	int render_setstate(shaderpass_t *pass, uint_t lmtex);
	void render_clearstate(shaderpass_t *pass);
	void render_pushface_deformed(int shadernum, face_t *face);

	arrays_t arrays;
	/*end of rendering backend */
	void find_start_pos();

	bool enableCollDetect;
	LightMode lightMode;
	bool fogMode;

	void render_transparent(facelist_t *facelist);

	//particle system stuff
	struct tEmitter emitter;

public:
	RenderEngine();
	~RenderEngine();
	void setBSP(BSPDataModel *bspDM);
	void render_init();
	void render_scene();
	void move(float move, float strafe, float jump, double intervaltime);
	void moveEye(int dx, int dy);
	double getFrameTime();
	void setFrameTime(double time);

    int checkCollisionMultiple(int n,Sphere *Sp, int* CollList);
    int checkLeafMultiple     (int n,Sphere *Sp, int* CollList);
    int checkCollision(int n,Sphere *Sp);
    int checkLeaf     (int n,Sphere *Sp);
    int checkBrush    (int n,Sphere *Sp);
	int checkInvalidLocation (int n, Sphere *Sp);
	int checkBrush (int n, float x, float y, float z, float dx, float dy, float dz, float ln, float &ratio);
	int checkLeaf  (int n, float x, float y, float z, float dx, float dy, float dz, float ln, float &ratio);
	int checkCollision (int n, float x, float y, float z, float dx, float dy, float dz, float ln, float &ratio);
	int checkPlayerCollision (float x, float y, float z, float dx, float dy, float dz, float ln, float &distance);
	int getClosestPlayer(float x, float y, float z);
	int getClosestObject(float x, float y, float z, float& distance);


    void setCollisionDetection(bool state);
	inline bool getCollisionDetection() {return enableCollDetect; }
	inline LightMode getLight() { return lightMode; }
	void setLight(LightMode newMode);
	void setFog(bool state, GLfloat *fogcolorv, GLfloat density);
 	void renderModel(XPModel *);
 	BasicGraphicList *getBasicGraphicList();
 	ModelTypeList *getModelTypeList();
 	XPModelList *getXPModelList();
 	void swapViewer();
	Player *getViewer();

};

#endif
