#ifndef _MODELTYPEH_
#define _MODELTYPEH_

#define MAXPARTSPERTYPE 10
#define MAXNAMELENGTH 30

struct Part{
	char name[MAXNAMELENGTH];
	//relative to origin of modeltype
	float position[3];
	float orienation[3];
	float scale;
};

struct PartEntry{
	Part part;
	int basicGraphicIndex;
};

class ModelType{
private:
	int numParts;
	//index to items in BasicGraphicList
	PartEntry parts[MAXPARTSPERTYPE];
	char name[MAXNAMELENGTH];

public:
	ModelType();
	ModelType(char *name);
	virtual ~ModelType();
	void setNumParts(int num);
	void setPart(int partNum,int basicGraphicIndex,Part *part);
	int getGraphicIndexForPart(int partNum);
	Part *getPart(int partNum);
	int getNumParts();
	const char *getName();
};
#endif