#ifndef _GRAPHICMODELH_
#define _GRAPHICMODELH_

#include <GL/glut.h>
#include "algebra.h"
#include "matrix.h"
#include "box.h"

struct sample_MATERIAL{
 GLfloat ambient[3];
 GLfloat diffuse[3];
 GLfloat specular[3];
 GLfloat emission[3];
 GLfloat alpha;
 GLfloat phExp;
 int   texture;
};
struct sample_TEXTURE{
 char name[30];
 GLuint  id;
};


struct DIB2D;
struct GLTXTLOAD;

#define MAX_ACTIONS 10
#define MAX_KEYFRAMES 10
#define MAX_SUBPARTS 10
#define ACTION_NAME_LENGTH 40
#define PART_NAME_LENGTH 40

static int NUM_KEY_FRAMES[MAX_ACTIONS];
static float KEY_FRAME_TIMES[MAX_ACTIONS][MAX_KEYFRAMES];
static float KEY_FRAME_TRANS[MAX_ACTIONS][MAX_KEYFRAMES][MAX_SUBPARTS][6];	// rot x, rot y, rot z, dx, dy, dz

class GraphicModel{
	private:
		GLint list;
		int numMaterials;
		int numFace_indices;
		int numVertices;
		int numNormals;
		int numTextures;
		int numMaterial_refs;
		char typeName[80];
	
		sample_MATERIAL *materials;
		sample_TEXTURE *texture_maps;
		short (*face_indicies)[9];
		GLfloat (*vertices)[3];
		GLfloat (*normals)[3];
		GLfloat (*textures)[2];
		int (*material_ref)[2];

		int numSubParts;
		char **partNames;
		Box **partBox;
		float (*partOrigin)[3];
		int *vertPartList;		
		int *partDependancy;

		int numActions;
		char **actionNames;
		int *actionNumFrames;
		Box ****actionPartBox;
		float *actionFinishTime;
		GLint **actionLists;

		long ScanBytes(int pixWidth, int bitsPixel);
		bool ScaleImage(DIB2D &dib,GLTXTLOAD&p);
		void LoadTexture(char*filename);
		void LoadTexture(int n);

		void MyMaterial(GLenum mode,GLfloat *f,GLfloat alpha);
		void SelectMaterial(int i);
		GLint Gen3DObjectList();
		vec3 minCorner;
		vec3 maxCorner;
		void computeBoundingBox();
		
	public:
		GraphicModel();
		virtual ~GraphicModel();
		bool readFile(const char *path,const char *name);
		virtual GLint getDisplayList();
		virtual GLint generateList();
		GLint genTransformList();
		GLint genTransformList(Matrix **transformList);
		GLint getDisplayList(int action, float time);
		GLint getDisplayList(int action, int frame);
		const char * getTypeName();
		void getUnscaledBoundingBox(vec3 &corner1,vec3 &corner2);
		int getNumParts() { return numSubParts; }
		void getBoxCorners(float* f);
		int getFinishTime(int action) {return actionFinishTime[action];}
};

#endif