#include "BasicGraphicList.h"
#include "GraphicModel.h"

#ifdef WIN32
#define PATHSTR "resources\\models\\"
#else
#define PATHSTR "resources/models/"
#endif

static const char *fileNames []={
"leet.xp", "grunt.xp", "leet1.xp","marine.xp","samurai.xp",
"pag.xp", "pistol.xp", "rocketl.xp", 
"rocket.xp", "bullet.xp", 
"ammo1.xp","ammo2.xp","ammo3.xp","ammo4.xp",
"matrixcan.xp",
"sargeHead.xp","sargeUpper.xp","sargeLower.xp",
};

bool BasicGraphicList::initList(){
	GraphicModel *model;
	bool success=true;

	char pathstr[256];
	strcpy(pathstr, PATHSTR);

	for(int i=0;i<( sizeof(fileNames)/sizeof(char *));i++){
		model=new GraphicModel;

		if(!model->readFile(pathstr, fileNames[i])){
			success=false;
			freeList();
			break;
		}
		model->generateList();
		graphicModelVector.push_back(model);
	}
	return success;


}

void BasicGraphicList::freeList(){
	std::vector<GraphicModel *>::iterator iter=graphicModelVector.begin();
	while(iter != graphicModelVector.end()){
		delete *iter;
		iter++;
	}
	graphicModelVector.clear();
}

GraphicModel *BasicGraphicList::getGraphicModel(int index){
	return graphicModelVector[index];
}

int BasicGraphicList::getLength(){
	return graphicModelVector.size();
}

BasicGraphicList::~BasicGraphicList(){
	freeList();

}

BasicGraphicList::BasicGraphicList(){
}

GraphicModel *BasicGraphicList::getGraphicModel(const char* name){

	std::vector<GraphicModel *>::iterator iter=graphicModelVector.begin();
	while(iter != graphicModelVector.end()){
		if(strcmp((*iter)->getTypeName(),name)==0){
			return *iter;
		}
		iter++;
	}

	return NULL;
}

int BasicGraphicList::getIndex(const char *name){
	std::vector<GraphicModel *>::iterator iter=graphicModelVector.begin();
	int i=0;
	while(iter != graphicModelVector.end()){
		if(strcmp((*iter)->getTypeName(),name)==0){
			return i;
		}
		iter++;
		i++;
	}

	return -1;
}
