#include "MainMenu.h"
#include "main.h"

#include "MenuScreen.h"
#include "SoundManager.h"

#ifdef WIN32

#define OPENING "resources\\images\\menu\\opening.ppm"

#define MENU1 "resources\\images\\menu\\menu1.ppm"
#define MENU2 "resources\\images\\menu\\menu2.ppm"
#define MENU3 "resources\\images\\menu\\menu3.ppm"
#define MENU4 "resources\\images\\menu\\menu4.ppm"

#define MENU1H "resources\\images\\menu\\menu1h.ppm"
#define MENU2H "resources\\images\\menu\\menu2h.ppm"
#define MENU3H "resources\\images\\menu\\menu3h.ppm"
#define MENU4H "resources\\images\\menu\\menu4h.ppm"

#define BASS17 "resources\\sounds\\bass17.wav"
#define CHORD10 "resources\\sounds\\chord10.wav"
#define MENUWAV "resources\\sounds\\menu.wav"
#else

#define OPENING "resources/images/menu/opening.ppm"

#define MENU1 "resources/images/menu/menu1.ppm"
#define MENU2 "resources/images/menu/menu2.ppm"
#define MENU3 "resources/images/menu/menu3.ppm"
#define MENU4 "resources/images/menu/menu4.ppm"

#define MENU1H "resources/images/menu/menu1h.ppm"
#define MENU2H "resources/images/menu/menu2h.ppm"
#define MENU3H "resources/images/menu/menu3h.ppm"
#define MENU4H "resources/images/menu/menu4h.ppm"

#define BASS17 "resources/sounds/bass17.wav"
#define CHORD10 "resources/sounds/chord10.wav"
#define MENUWAV "resources/sounds/menu.wav"
#endif


MenuScreen* frontPage;
SoundObject *mainmenuSound;
SoundObject *menuItemSound;
extern SoundManager *soundManager;


void mainmenu_display()
{
	if (frontPage->getRefresh()) {
		glClear(GL_COLOR_BUFFER_BIT);	
		frontPage->display();
		glutSwapBuffers();
	}		
}

void mainmenu_idle()
{
    mainmenu_display();
}


void mainmenu_mouse(int button, int state, int x, int y)
{
	int sel;
	sel = frontPage->returnSelect(x,y);
	if (sel>=0){
		frontPage->select(sel);
		if (button == GLUT_LEFT_BUTTON)
			switch (sel)
			{
			case 0 :
				setGameState(PLAY);
				break;
			case 1:
				setGameState(QUIT);
				break;
			}
	}
}


void mainmenu_mouse_motion(int x, int y)
{
	
	int sel;
	sel = frontPage->returnSelect(x,y);
	if (sel>=0 && sel!=frontPage->getSelection()){
		frontPage->select(sel);
		soundManager->playSound((*frontPage)[sel].getSound(),1,0);
	}		
}

void mainmenu_keyboard (unsigned char key, int x, int y)
{
	switch (key)
	{
	case GLUT_KEY_UP:
		frontPage->selectPrev();
		soundManager->playSound((*frontPage)[frontPage->getSelection()].getSound(),1,0);
		break;
	case GLUT_KEY_DOWN:
		frontPage->selectNext();
		soundManager->playSound((*frontPage)[frontPage->getSelection()].getSound(),1,0);
		break;
	case 13:
		if (frontPage->getSelection()==0) setGameState(PLAY);
		if (frontPage->getSelection()==0) setGameState(QUIT);
		break;
	case 27:
		setGameState(QUIT);
		break;
	}
	printf ("%d\n", (int)key);
}

void mainmenu_keyboardspc (int key, int x, int y)
{
	switch (key)
	{
	case GLUT_KEY_UP:
		frontPage->selectPrev();
		soundManager->playSound((*frontPage)[frontPage->getSelection()].getSound(),1,0);
		break;
	case GLUT_KEY_DOWN:
		frontPage->selectNext();
		soundManager->playSound((*frontPage)[frontPage->getSelection()].getSound(),1,0);
		break;
	case 13:
		if (frontPage->getSelection()==0) setGameState(PLAY);
		if (frontPage->getSelection()==0) setGameState(QUIT);
		break;
	case 27:
		setGameState(QUIT);
		break;
	}
	printf ("%d\n", (int)key);
}


void mainmenu_init()
{
	frontPage = new MenuScreen(2);
	mainmenuSound = new SoundObject();	
	menuItemSound  = new SoundObject();

	frontPage->loadImage(OPENING);		
	mainmenuSound->loadWave (CHORD10);	
	menuItemSound->loadWave (MENUWAV);
	soundManager->setChannelLoop(soundManager->playSound(mainmenuSound ,CHANNEL_BACKGROUND,0.4,-0.4),-1);

	int windowWidth = frontPage->getSizeX();
	int windowHeight = frontPage->getSizeY();

	(*frontPage)[0] = MenuObject(220,300, MENU1, MENU1H, menuItemSound);
	(*frontPage)[1] = MenuObject(220,400, MENU4, MENU4H, menuItemSound);

    glutDisplayFunc(mainmenu_display);
    glutMouseFunc(mainmenu_mouse);
    glutMotionFunc(mainmenu_mouse_motion);
	glutPassiveMotionFunc(mainmenu_mouse_motion);
    glutKeyboardFunc(mainmenu_keyboard);    
	glutSpecialFunc (mainmenu_keyboardspc);
    glutIdleFunc(mainmenu_idle);
	

	glMatrixMode (GL_PROJECTION);
	glLoadIdentity();
	gluOrtho2D (0,(GLfloat)windowWidth,(GLfloat)windowHeight,0);
    glMatrixMode (GL_MODELVIEW);
	glLoadIdentity();
	glEnable (GL_BLEND);
	glBlendFunc (GL_SRC_ALPHA, GL_ONE);

	glFlush();
}

void mainmenu_finish()
{
	soundManager->stop();

	delete frontPage;
	delete mainmenuSound;
	delete menuItemSound;
}
