#include "Movable.h"

void Movable::setPosition(vec3 pos)
{
	position=pos;
}

void Movable::setOrientation(vec3 vector)
{
	orientation=vector;

}

void Movable::moveAsOriented(float increment)
{
	
	position=position+(velocity*increment);
	velocity=velocity+acceleration*increment;

	
}

vec3 Movable::getPosition()
{
	return position;
}

vec3 Movable::getOrientation()
{
	return orientation;
}

Movable::Movable()
{
	orientation[0]=0;
	orientation[1]=0;
	orientation[2]=0;
	velocity[0]=0;
	velocity[1]=0;
	velocity[2]=0;
	acceleration[0]=0;
	acceleration[1]=0;
	acceleration[2]=0;

}

Movable::~Movable(){
}

void Movable::moveInDirection(vec3 vector)
{
	position=position+vector;
}

void Movable::setVelocity(vec3 vel)
{
	velocity=vel;

}

vec3 Movable::getVelocity(){
	return velocity;
}

void Movable::setAcceleration(vec3 accl){
	acceleration=accl;
}

vec3 Movable::getAcceleration(){
	return acceleration;
}