#ifndef _GAMESTATEH_
#define _GAMESTATEH_
#include <math.h>
#include <sys/types.h>

#ifdef WIN32
#include <winsock2.h>
#include <sys/timeb.h>
#else
#include <sys/time.h>
#endif

#include "globals.h"
#include "NetworkCommands.h"
#include "ClientState.h"

#include "nl.h"
#include "ServerModelList.h"
//millisecond values
#define FOGCURFEW 210000
#define LIGHTCURFEW 180000

#define FOGFXDUR 45000
#define LIGHTFXDUR 60000

extern ClientState* clientStates[MAX_CLIENTS];


class GameState
{
private:
	unsigned long curtime;
	unsigned long delta;

	bool lightFX;
	unsigned long lightTSLFX;
	unsigned long lightFXtime;
	float pLightFX;

	bool fogFX;
	float pFogFX;
	unsigned long fogTSLFX;
	unsigned long fogFXtime;
	float fogcolor[3];
	float density;
	

	void getTime();
	ServerModelList staticModelList;
	void initStaticModelList();
	ServerModelList projectileList;

public:
	


	vec3 startPosition;
	vec3 startOrientation;
	int playerCount;

	GameState( float pLightFX, float pFogFX);
	~GameState();

	bool updateState(); //main function to recompute everything before sending it off to the client
	int makeStateForNewPlayer(NLsocket sock,unsigned char sessionToken);
	void projectileCreated();
	void projectileRemoved();
	void projectileUpdated();
	ServerModelList *getStaticModelList();
	ServerModelList *getProjectileList();
};

#endif
