#ifndef _TRANSFORMH_
#define _TRANSFORMH_

#include <math.h>
#include "matrix.h"

typedef matrix<float> Matrix;

static Matrix dummyTrans(4,4);

class Transform
{
public:
	Transform ();
	Transform (Matrix rotation, Matrix translation);
	Transform (Matrix m);
	Transform (float x, float y, float z);
	Transform (float alpha, float beta, float gamma, float x, float y, float z);

	void setIdentitiy ();
	void setTranslation (float x, float y, float z);
	void setTranslation (Matrix translation);
	void setRotation (Matrix rot);
	void addTranslation (float x, float y, float z);
	void addTranslation (Matrix translation);
	void addRotation (Matrix rot);	
	void addRotationX (float alpha);
	void addRotationY (float alpha);
	void addRotationZ (float alpha);
	void addTransform (Matrix t);
	void addTransform (Transform t);
	Matrix getTransform();
	Matrix getRotation();
	Matrix getTranslation();

	void print();

private:
	Matrix trans;
};


#endif