#include "transform.h"


Transform::Transform ()
{
	Matrix trans(4,4);
	(*this).setIdentitiy();
}

Transform::Transform (Matrix rotation, Matrix translation)
{
	Matrix trans(4,4);
	for (int i=0;i<3;i++){
		for (int j=0;i<3;i++)
			trans (i,j) = rotation(i,j);
		trans (i,4) = translation (i,0);
	}
	trans(3,0) = 0;
	trans(3,1) = 0;
	trans(3,2) = 0;
	trans(3,3) = 1;

}

Transform::Transform (Matrix m)
{
	trans = m;
}

Transform::Transform (float x, float y, float z)
{
	Matrix trans(4,4);
	(*this).setIdentitiy();
	(*this).addTranslation(x,y,z);
}

Transform::Transform (float alpha, float beta, float gamma, float x, float y, float z)
{
	Matrix trans(4,4);
	(*this).setIdentitiy();
	(*this).addRotationX(alpha);
	(*this).addRotationY(beta);
	(*this).addRotationZ(gamma);
	(*this).addTranslation(x,y,z);
}

void Transform::setIdentitiy ()
{
	for (int i=0;i<4;i++)
		for (int j=0;j<4;j++)
			trans(i,j) = (i==j);
}

void Transform::setTranslation (float x, float y, float z)
{
	trans(0,3) = x;
	trans(1,3) = y;
	trans(2,3) = z;
}

void Transform::setTranslation (Matrix translation)
{
	trans(0,3) = translation(0,0);
	trans(1,3) = translation(1,0);
	trans(2,3) = translation(2,0);
}

void Transform::setRotation (Matrix rot)
{
	for (int i=0;i<3;i++)
		for (int j=0;j<3;j++)
			trans(i,j) = rot(i,j);
}

void Transform::addTranslation (float x, float y, float z)
{
	trans (0,3) += x;
	trans (1,3) += y;
	trans (2,3) += z;
}

void Transform::addTranslation (Matrix translation)
{
	trans(0,3) += translation(0,0);
	trans(1,3) += translation(1,0);
	trans(2,3) += translation(2,0);
}

void Transform::addRotation (Matrix rot)
{
	for (int i=0;i<3;i++){
		for (int j=0;i<3;i++)
			dummyTrans (i,j) = rot(i,j);
		dummyTrans (i,4) = 0;
	}
	dummyTrans(3,0) = 0;
	dummyTrans(3,1) = 0;
	dummyTrans(3,2) = 0;
	dummyTrans(3,3) = 1;

	trans = dummyTrans * trans;
}

void Transform::addTransform (Matrix t)
{
	trans = t * trans;
}

void Transform::addTransform (Transform t)
{
	trans = t.getTransform() * trans;
}

void Transform::addRotationX (float alpha)
{
	for (int i=0;i<4;i++)
		for (int j=0;j<4;j++)
			dummyTrans (i,j) = (i==j);		
	
	dummyTrans(1,1) = cos(alpha);
	dummyTrans(1,2) = -sin(alpha);
	dummyTrans(2,1) = -dummyTrans(1,2);
	dummyTrans(2,2) = dummyTrans(1,1);

	trans = dummyTrans * trans;
}

void Transform::addRotationY (float alpha)
{
	for (int i=0;i<4;i++)
		for (int j=0;j<4;j++)
			dummyTrans (i,j) = (i==j);		
	
	dummyTrans(0,0) = cos(alpha);
	dummyTrans(0,2) = -sin(alpha);
	dummyTrans(2,0) = -dummyTrans(0,2);
	dummyTrans(2,2) = dummyTrans(0,0);

	trans = dummyTrans * trans;
}

void Transform::addRotationZ (float alpha)
{
	for (int i=0;i<4;i++)
		for (int j=0;j<4;j++)
			dummyTrans (i,j) = (i==j);		
	
	dummyTrans(0,0) = cos(alpha);
	dummyTrans(0,1) = -sin(alpha);
	dummyTrans(1,0) = -dummyTrans(0,1);
	dummyTrans(1,1) = dummyTrans(0,0);

	trans = dummyTrans * trans;
}

Matrix Transform::getTransform()
{
	return trans;
}

Matrix Transform::getRotation()
{
	Matrix a(3,3);
	for (int i=0; i<3; i++)
		for (int j=0; j<3; j++)
			a(i,j) = trans(i,j);
	return a;
}

Matrix Transform::getTranslation()
{
	Matrix a(3,1);
	for (int i=0; i<3; i++)
		a(i,0) = trans(i,3);
	return a;
}

void Transform::print()
{
}
