#ifndef PPMPICTURE_H
#define PPMPICTURE_H

#include <GL/glut.h>
#include "string.h"
#include <stdio.h>
#include <stdlib.h>


#define GET_RED(P)   ((P)&0xFF)
#define GET_GREEN(P) (((P)>>8)&0xFF)
#define GET_BLUE(P)  (((P)>>16)&0xFF)
#define GET_ALPHA(P) (((P)>>24)&0xFF)

#define SET_RED(P,C)   (P=(((P)&0xFFFFFF00)|(C)))
#define SET_GREEN(P,C) (P=(((P)&0xFFFF00FF)|((C)<<8)))
#define SET_BLUE(P,C)  (P=(((P)&0xFF00FFFF)|((C)<<16)))
#define SET_ALPHA(P,C) (P=(((P)&0x00FFFFFF)|((C)<<24)))


class ppmPicture
{
public:
	ppmPicture();
	~ppmPicture();

	ppmPicture(ppmPicture const &a);
	ppmPicture const& operator=(ppmPicture const &a);
	void addPicture(ppmPicture a, int dx, int dy);

	void display();
	void display(int x, int y);
	bool load (const char* filename);
	bool load (const char * path,const char *name);

	int getSizeX() { return size_x; }
	int getSizeY() { return size_y; }
	const char* getTypeName();

	void calculateAlphaValue();
	void calculateAlphaLightness();
	void calculateAlphaMask(int mr, int mg, int mb);
	void calculateAlphaThreshold(int val);
	void calculateAlphaThreshold(float val);

private:
	int size_x,size_y;
	unsigned long* pixels;
	char typeName[80];
};

#endif