#include "ppmPicture.h"

ppmPicture::ppmPicture()
{
	size_x = 0;
	size_y = 0;
	pixels = NULL;
}

ppmPicture::~ppmPicture()
{
	if (pixels!=NULL)
		free (pixels);
}

ppmPicture::ppmPicture(ppmPicture const &a)
{
	size_x = a.size_x;
	size_y = a.size_y;
	if (a.pixels!=NULL && size_x!=0 && size_y!=0){		
		pixels = (unsigned long*)(malloc(size_x*size_y*sizeof(unsigned long)));
		memcpy (pixels, a.pixels, size_x*size_y*sizeof(unsigned long));
		//printf ("copying\n");
	}
	else
		pixels = NULL;
}

ppmPicture const& ppmPicture::operator=(ppmPicture const &a)
{
	this->size_x = a.size_x;
	this->size_y = a.size_y;
	if (a.pixels!=NULL && size_x!=0 && size_y!=0){		
		this->pixels = (unsigned long*)(malloc(size_x*size_y*sizeof(unsigned long)));
		memcpy (this->pixels, a.pixels, size_x*size_y*sizeof(unsigned long));
		//printf ("assigning\n");
	}
	else
		this->pixels = NULL;

	return (*this);
}


bool ppmPicture::load(const char * path,const char *name)
{
	char fileName[256];
	strcpy(fileName,path);
	strcat(fileName,name);
	return (load (fileName));
}


bool ppmPicture::load(const char* Filename)
{
  FILE *Input=fopen(Filename,"rb");
  if (!Input)
    return false;
  strcpy (typeName, Filename);

  /* Read magic number. */

  fscanf(Input,"P6\n");

  /* Comment line(s). */

  int Data;
  while ((Data=getc(Input))=='#')
    fscanf(Input,"%*[^\n]\n");
  ungetc(Data,Input);

  /* Image dimensions. */

  if (fscanf(Input,"%d %d",&size_x,&size_y)!=2 ||
      size_x==0 || size_y==0)
	return false;

  /* Maximum value in image. */

  fscanf(Input,"%*d%*c");

  /* Allocate space for the image. */

  int image_size=size_x*size_y;

  if (pixels!=NULL) free(pixels);
  pixels=(unsigned long*)(malloc(image_size*sizeof(unsigned long)));

  /* Load image. */

  unsigned long* Buffer=pixels;
  int line=0;
  int col=0;
  unsigned long a;

  for (int i=0;i<image_size;i++,Buffer++) {
	Buffer = &pixels[(size_y-1-line)*size_x + col];
    fread(&a,3,1,Input);	
	SET_ALPHA (a,255);
	
	*Buffer = a;
	col++;
	if (col>=size_x) {col = 0; line++;}

  }

  fclose(Input);
  return true;
}

void ppmPicture::addPicture(ppmPicture a, int dx, int dy)
{
	int i,j;
	int x,y;
	for (i=0;i<a.size_x;i++){
		x = i + dx;
		for (j=0;j<a.size_y;j++){
			y = j + dy;
			if (x>=0 && y>=0 && x<size_x && y<size_y)
				pixels[x+y*size_x] = a.pixels[i+j*a.size_x];
		}
	}
}

void ppmPicture::display()
{	
	glRasterPos2i(0,0);
	glDrawPixels (size_x, size_y, GL_RGBA, GL_UNSIGNED_BYTE, pixels);
}

void ppmPicture::display(int x,int y)
{	
	glRasterPos2i(x,y);
	glDrawPixels (size_x, size_y, GL_RGBA, GL_UNSIGNED_BYTE, pixels);
}

void ppmPicture::calculateAlphaValue()
{
	int i;
	int r,g,b;
	int a;
	unsigned long* buffer = pixels;	
	for (i=0;i<size_x*size_y;i++,buffer++){
		r = GET_RED   (*buffer);
		g = GET_GREEN (*buffer);
		b = GET_BLUE  (*buffer);
		a=r;
		if (g>r && g>b) a = g;
		if (b>r && b>g) a = b;
		SET_ALPHA (*buffer,a);
	}
}

void ppmPicture::calculateAlphaLightness()
{
	int i;
	int r,g,b;
	int a;
	unsigned long* buffer = pixels;	
	for (i=0;i<size_x*size_y;i++,buffer++){
		r = GET_RED   (*buffer);
		g = GET_GREEN (*buffer);
		b = GET_BLUE  (*buffer);
		a = (r+g+b)/3;
		SET_ALPHA (*buffer,a);
	}
}

void ppmPicture::calculateAlphaMask(int mr, int mg, int mb)
{
	int i;
	int r,g,b;
	int a;
	unsigned long* buffer = pixels;	
	for (i=0;i<size_x*size_y;i++,buffer++){
		r = GET_RED   (*buffer);
		g = GET_GREEN (*buffer);
		b = GET_BLUE  (*buffer);
		if (r==mr && g==mg && b==mb) a = 0;
		else a = 255;		
		SET_ALPHA (*buffer,a);
	}
}

void ppmPicture::calculateAlphaThreshold(float val)
{
	int i;
	int r,g,b;
	int a;
	float curval;
	float max = 3*255;
	unsigned long* buffer = pixels;	
	for (i=0;i<size_x*size_y;i++,buffer++){
		r = GET_RED   (*buffer);
		g = GET_GREEN (*buffer);
		b = GET_BLUE  (*buffer);
		curval = (r+g+b)/max;
		if (curval>val) a = 255;
		else a = 0;
		SET_ALPHA (*buffer,a);
	}
}

void ppmPicture::calculateAlphaThreshold(int val)
{
	int i;
	int r,g,b;
	int a;
	unsigned long* buffer = pixels;	
	for (i=0;i<size_x*size_y;i++,buffer++){
		r = GET_RED   (*buffer);
		g = GET_GREEN (*buffer);
		b = GET_BLUE  (*buffer);
		a = (((r+g+b)/3) > val) ? 255 : 0;
		SET_ALPHA (*buffer,a);
	}
}

const char* ppmPicture::getTypeName(){
	return typeName;
}
