#include "play.h"
#include "main.h"
#include "stdlib.h"

#include "RenderEngine.h"
#include "Player.h"
#include "PlayerList.h"
#include "BasicGraphicList.h"
#include "ModelTypeList.h"
#include "XPModelList.h"
#include "XPSubPart.h"
#include "ppmPictureList.h"
#include "GraphicModel.h"
#include "NetworkManager.h"
#include "SoundObjectList.h"

Player *viewer;
PlayerList *playerList;
ModelTypeList *modelTypeList;
BasicGraphicList *basicGraphicList;
XPModelList *xpModelList;
ppmPictureList *pictureList;
SoundObjectList *soundList;
XPModelList *projectileList;

RenderEngine *renderEngine;

bool matrixmode;

extern NetworkManager *networkManager;
#ifdef SOUND_AV
extern SoundManager *soundManager;
#endif

static int ox = 0, oy = 0;
static int move = 0, strafe = 0, jump = 0;
static double starttime; 
static int prevTime=0;

static float moveTime=0;
static int moveStep=0;
int musicChannel=0;

extern char serveraddrport[20];


/*
static void move_eye(double intervaltime)
{
	renderEngine->move(move, strafe, intervaltime);
}
*/

void play_init()
{
	matrixmode = false;

	basicGraphicList=new BasicGraphicList;
	modelTypeList=new ModelTypeList;
	xpModelList=new XPModelList;
	playerList=new PlayerList;
	pictureList = new ppmPictureList;
	soundList = new SoundObjectList;
	projectileList=new XPModelList;

	if(!basicGraphicList->initList()) printf("Basic GraphicList failed to load\n");
	modelTypeList->initList(basicGraphicList);
	if (!pictureList->initList()) printf ("Picture List failed to load\n");
	if (!soundList->initList()) printf ("Sound List failed to load\n");
	
	renderEngine = new RenderEngine;
	renderEngine->render_init();
	
	int playerID;

	if ( (playerID=networkManager->doConnect(serveraddrport) )< 0)
	{
		printf("NetworkManager: Can't connect to the server. Reverting to main menu\n");
		setGameState(MAIN_MENU);
	}
	else{
		
		viewer=playerList->getPlayer(playerID);
		if(viewer==NULL){
			printf("NetworkManager: Can't get playerID Reverting to main menu\n");
			setGameState(MAIN_MENU);
		}
		
	}
#ifdef SOUND_AV
	musicChannel = soundManager->playSound(soundList->getSound(0), CHANNEL_HIGH_PRIORITY, .8, 0);	
	soundManager->setChannelLoop(musicChannel,1);
#endif
	starttime = (double)glutGet(GLUT_ELAPSED_TIME) / 1000.0;

    glutDisplayFunc(play_display);
    glutIdleFunc(play_display);
    glutMouseFunc(play_mouse);
    glutMotionFunc(play_motionFunc);
    glutKeyboardFunc(play_keyboard);
    glutKeyboardUpFunc(play_keyboardUp);
}



void play_display()
{
    double time;
	int curtime;
	static int oldtime=0;


	asyncRecvUpdate();
	asyncRecvUpdate();
	asyncRecvUpdate();
	asyncRecvUpdate();
	
	curtime = glutGet(GLUT_ELAPSED_TIME);	
    time = (double) curtime / 1000.0 - starttime;
	printf ("my player id %d\n", viewer->getPlayerID());

	// matrix mode toggle
	if (viewer->matrixOwner==viewer->getPlayerID() && matrixmode == true && (curtime - viewer->matrixStartTime) > 10000){
		printf ("turning off matrix mode...\n");		
		unsigned char packet[2];
		packet[0] = ENDMATRIX;
		packet[1] = viewer->getPlayerID();
		networkManager->sendPacket(packet,2);
	}
	
	// projectile collision
	if(prevTime!=0){
		XPModel* curProj;
		float delT = (curtime-prevTime)/1000.0;
		vec3 oldPos, newPos, dPos;
		float ratioM;
		float distanceP;
		float distanceM;


		for (int i=0; i<projectileList->getLength(); i++){
			curProj = projectileList->getModel(i);
			oldPos = curProj->getPosition();
			curProj->moveAsOriented (delT);
			if (curProj->getOwner() == viewer->getPlayerID()){
				newPos = curProj->getPosition();
				dPos [0] = newPos[0] - oldPos[0];
				dPos [1] = newPos[1] - oldPos[1];
				dPos [2] = newPos[2] - oldPos[2];
				distanceM  = sqrt(dPos[0]*dPos[0]+dPos[1]*dPos[1]+dPos[2]*dPos[2]); 
				renderEngine->checkCollision(0,oldPos[0],oldPos[1],oldPos[2],dPos[0],dPos[1],dPos[2],1,ratioM);
				int playerColl = renderEngine->checkPlayerCollision(oldPos[0],oldPos[1],oldPos[2],dPos[0],dPos[1],dPos[2],1,distanceP);
				distanceM *= ratioM;

				//printf ("collision %f   %f id %d\n", distanceM, distanceP,playerColl);				
				if (distanceM > 0 && distanceP > 0){
					if (distanceP < distanceM){
						//hit player
						unsigned char dam[3];					
						dam[0] = DAMAGE;
						dam[1] = playerColl;
						if (curProj->getModelTypeIndex() == 8) dam[2] = 10+(rand()/(RAND_MAX/10));
						else if (curProj->getModelTypeIndex() == 9) dam[2]  = 5+(rand()/(RAND_MAX/5));
						else if (curProj->getModelTypeIndex() == 10) dam[2] = 40+(rand()/(RAND_MAX/30));
						else dam[2] = 0;
						networkManager->sendPacket(dam,3);					
						viewer->removeProjectile(curProj);
					}
					else{
					}					
				}
				else if (distanceM > 0){
					//hit wall
					viewer->removeProjectile(curProj);
				}
				else if (distanceP > 0){
					//hit player				
					unsigned char dam[3];
					dam[0] = DAMAGE;
					dam[1] = playerColl;
					if (curProj->getModelTypeIndex() == 8) dam[2]  = 10+(rand()/(RAND_MAX/10));
					else if (curProj->getModelTypeIndex() == 9) dam[2]  = 5+(rand()/(RAND_MAX/5));
					else if (curProj->getModelTypeIndex() == 10) dam[2] = 40+(rand()/(RAND_MAX/30));
					else dam[2] = 0;
					networkManager->sendPacket(dam,3);				
					viewer->removeProjectile(curProj);
				}
				if (fabs(newPos[0])>1e4 || fabs(newPos[1])>1e4 || fabs(newPos[2])>1e4) viewer->removeProjectile(curProj);
			}
		}
		playerList->updateAnimationTime((curtime-prevTime)/1000.0);
	}

	int curaction = 0;	
	vec3 plV = viewer->getVelocity();
	if (move || strafe) curaction = 1;
	if (abs(plV[2])>0) curaction = 2;
	
	if (curaction!=viewer->getAction()){
		viewer->setPreviousAction(viewer->getAction());
		viewer->setAction(curaction);
		viewer->setAnimationTime(0.0f);
	}

	prevTime=curtime;


	double intervaltime = time - renderEngine->getFrameTime(); //g_frametime;
	if (matrixmode && (glutGet(GLUT_ELAPSED_TIME)-viewer->matrixStartTime)>10000) intervaltime /= 4;

	// footsteps
	if ((move || strafe) && (!jump)){
		moveTime += intervaltime;
		if (moveTime>.3){
			moveStep = ((moveStep+1) %4);
			moveTime = 0;
#ifdef SOUND_AV
			soundManager->playSound(soundList->getSound(10+moveStep), CHANNEL_HIGH_PRIORITY, 1, 0);
#endif
		}
	}
	else if (!move && !strafe )
		moveTime = 0;

    renderEngine->setFrameTime(time);
	renderEngine->move(move, strafe, jump, intervaltime);
	
    
    renderEngine->render_scene();


    glutSwapBuffers();


	//DONT send a player update to the server too often. it will kill the server
	// (and the network)
	if (curtime - oldtime > MINCLIENTUPDATETIMEPERIOD)
	{
		oldtime = curtime;
		/*
		if (viewer->getMotionState() != NOTMOVING)
			viewer->sendUpdateToServer();
		*/
		viewer->sendUpdateToServer();
		if (viewer->getMotionState() == TURNLEFT)
			viewer->setMotionState(NOTMOVING);
	}
}


void play_mouse(int button, int state, int x, int y)
{
    ox = x; oy = y;
}

void play_motionFunc(int x, int y)
//ui_passive_mouse_motion(int x, int y)
{
    //renderEngine->moveEye( ox -x, oy - y);
	
	if (viewer->getMotionState() == NOTMOVING)
		viewer->setMotionState(TURNLEFT);	
	viewer->lookUp((oy-y)/(MOUSE_SPEED_Y*1.0));
	viewer->turnLeft((ox-x)/(MOUSE_SPEED_X*1.0));
	
    ox = x; oy = y;    
}

void
play_keyboard(unsigned char key, int x, int y)
{
    switch (key)
    {
	case 'w':
	    move = 1;
		viewer->setMotionState(GOFORWARD);
	    break;
	case 's':
	    move = -1;
		viewer->setMotionState(GOBACK);
	    break;
	case 'a':
	    strafe = -1;
		viewer->setMotionState(STRAFELEFT);
	    break;
	case 'd':
	    strafe = 1;
		viewer->setMotionState(STRAFERIGHT);
	    break;
	case ' ':
		jump = 1;
		//satyam
		//set viewer motion state to jump
		break;
	case 27: //escape
		setGameState(MAIN_MENU);
		break;
	case '6':
		renderEngine->setLight(NORMAL);
		break;
	case '7':
		renderEngine->setLight(IR_GLASSES);
		break;
	case '8':
		renderEngine->setLight(NOLIGHTS);
		break;
	case '9':
		{
		GLfloat fogcolor[] = { 0.7, 0.7, 0.7, 1.0};
		renderEngine->setFog(true, fogcolor, 0.005);
		break;
		}
	case '0':
		renderEngine->setFog(false, NULL, 0);
		break;
	case '1':
		if (viewer->weapons[0].available) {
			renderEngine->getViewer()->activeWeapon = 0;
#ifdef SOUND_AV
			soundManager->playSound(soundList->getSound(16),CHANNEL_MEDIUM_PRIORITY,1,0);
#endif
		}
		break;
	case '2':
		if (viewer->weapons[1].available) {
			renderEngine->getViewer()->activeWeapon = 1;
#ifdef SOUND_AV
			soundManager->playSound(soundList->getSound(16),CHANNEL_MEDIUM_PRIORITY,1,0);
#endif
		}
		break;
	case '3':
		if (viewer->weapons[2].available) {
			renderEngine->getViewer()->activeWeapon = 2;
#ifdef SOUND_AV
			soundManager->playSound(soundList->getSound(16),CHANNEL_MEDIUM_PRIORITY,1,0);
#endif
		}
		break;
	case 'p':
		renderEngine->setCollisionDetection(!renderEngine->getCollisionDetection());
		break;
 	case 'x':
		renderEngine->getViewer()->fire();
		break;
	case 'm':		
		if (viewer->haveMatrix && matrixmode == false) {
			printf ("turning on matrix mode...\n");		
			viewer->haveMatrix = false;
			unsigned char packet[2];
			packet[0] = STARTMATRIX;
			packet[1] = viewer->getPlayerID();
			networkManager->sendPacket(packet,2);
			viewer->matrixStartTime = glutGet(GLUT_ELAPSED_TIME);
#ifdef SOUND_AV
			soundManager->playSound(soundList->getSound(18),CHANNEL_MEDIUM_PRIORITY,1,0);
#endif
		}
		break;
	case 'n':
		if (renderEngine->getLight()==NOLIGHTS && viewer->haveGlasses){
			renderEngine->setLight(IR_GLASSES);
			viewer->haveGlasses = false;
#ifdef SOUND_AV
			soundManager->playSound(soundList->getSound(18),CHANNEL_MEDIUM_PRIORITY,1,0);
#endif
		}
	case 'l':
	    //r_lockpvs = !r_lockpvs;
	    //if (r_lockpvs) printf("cluster: %d\n", r_eyecluster);
    break;
    }
}

void
play_keyboardUp(unsigned char key, int x, int y)
{
    switch (key)
    {
	case 'w':
	case 's':
	    move = 0;
		viewer->setMotionState(NOTMOVING);
	    break;

	case 'a':
	case 'd':
	    strafe = 0;
		viewer->setMotionState(NOTMOVING);
	    break;
	case ' ':
  		jump = 0;
		break;

    }
}

void
play_finish(void)
{

	//glFlush();

	networkManager->doDisconnect();
	delete renderEngine;
	delete basicGraphicList;
 	delete modelTypeList;
	delete playerList;
 	delete xpModelList;
	delete pictureList;
	delete soundList;
	delete projectileList;
}
