#ifndef _NETWORKMANAGERH_
#define _NETWORKMANAGERH_

#include <stdio.h>
#include <stdlib.h>

#include "nl.h"
#include "NetworkCommands.h"

class NetworkManager
{
private:
	NLsocket    clientsock;
	NLint group;
	int sessiontoken;

public:
	NetworkManager();
	~NetworkManager();
	int doConnect(char *servaddrport);
	void doDisconnect();
	inline int sendCommand(unsigned char cmd);
	int recvCommand(unsigned char *cmd);
	int sendPacket(unsigned char *packet, int len);
	int recvPacket(unsigned char *packet, int packetlen);
	void shutDown();
	int asyncRecvCommand(unsigned char *cmd);
};

#endif
