#include "MenuScreen.h"

MenuScreen::MenuScreen()
{
	numEntries = 0;
	selection = -1;
	refresh = true;
	options = NULL;		
}

MenuScreen::~MenuScreen()
{
	numEntries = 0;
	selection = -1;
	refresh = true;
	if (options != NULL)
		delete []options;
}


MenuScreen::MenuScreen(int n)
{
	if (n<=0){
		numEntries = 0;
		selection = -1;
		refresh = true;
		options = NULL;		
	}
	else {
		numEntries = n;
		selection = -1;
		refresh = true;
		options = new MenuObject[n];
	}
}

MenuObject& MenuScreen::operator[] (int n)
{
	return options[n];
}

MenuObject MenuScreen::operator[] (int n) const
{
	return options[n];
}

void MenuScreen::loadImage (char* Filename)
{
	Picture.load(Filename);
}

void MenuScreen::display()
{
	Picture.display(0,getSizeY());	
		
	for (int i=0; i<numEntries; i++){
		options[i].displayNormal();
	}	
	
	if (selection>=0)
		options[selection].displayHighlighted();	
	
	refresh = false;	
	
}

void MenuScreen::select(int n)
{
	selection = n;
	refresh = true;
}

int MenuScreen::returnSelect(int x,int y)
{	
	for (int i=0; i<numEntries; i++)
		if ( x > options[i].getX() && x < (options[i].getX()+options[i].getSizeX()) &&
			 y > options[i].getY() && y < (options[i].getY()+options[i].getSizeY()))
			 return i;

	return -1;
}

void MenuScreen::selectNext()
{
	selection++;
	if (selection>=numEntries)
		selection = 0;
	refresh = true;
}

void MenuScreen::selectPrev()
{
	selection--;
	if (selection<0)
		selection = numEntries-1;
	refresh = true;
}

void MenuScreen::selectNone()
{
	selection=-1;
	refresh = true;
}
