/* vector.h - used for manipulating/creating mathematical vectors */

#ifndef pvector_h

#define pvector_h

#include <math.h>

class PVector {

	public:
		bool IsZero();
		float x,y,z;

		void Translate(float dx, float dy, float dz);
		void Scale(float xScale, float yScale, float zScale);
		void Rotate(AXIS axis, float theta);
		float AngleTo(PVector * pTarget);

		float angleSubtended(AXIS plane, PVector * pv);
		void set(float x, float y, float z);
		// Constructor
		PVector(float x, float y, float z) { this ->x = x; this ->y = y; this ->z = z; }
		PVector() { x = y = z = 0.0f; }
		PVector(PVector & source) { x = source.x; y = source.y; z = source.z; }
		bool operator==(PVector & v) { return x == v.x && y == v.y && z == v.z; }

		void makeUnit();
		//static PVector makeUnit(PVector v) { return v.makeUnit(); }

		float getX() {	return x; }
		float getY() { return y; }
		float getZ() { return z; }

		//get magnitude of vector
		float getMag() { return ((float)sqrt(x*x+y*y+z*z)); }

		//dot product
		float dotProduct(PVector *pv) { return (x*pv ->getX()+y*pv ->getY()+z*pv ->getZ()); }

		//dist b/w two vectors
		float dist(PVector * v1) { PVector temp = *this; temp.subtract(v1); return temp.getMag(); }

		void add(PVector * v1);
		void subtract(PVector * v1);
		PVector cross(PVector * v1);
		void invert();
		void multiply(float scale);


		void setX(float tmp) { x=tmp; }
		void setY(float tmp) { y=tmp; }
		void setZ(float tmp) { z=tmp; }
};

#endif