/* pvector.cpp - source file for the pvector header file */

#include "stdafx.h"
#include "pvector.h"

#define SMALL 1.0e-8

void PVector::makeUnit() {
	float rep = getMag();

	if (rep < SMALL) {
		x = 0.0;
		y = 0.0;
		z = 0.0;
	} else {
		float temp = 1.0f / rep;
		x *= temp;
		y *= temp;
		z *= temp;
	}
}



void PVector::invert() {
	x = -x;
	y = -y;
	z = -z;
}


void PVector::add(PVector * v1) {
	x += v1 ->x;
	y += v1 ->y;
	z += v1 ->z;
}


void PVector::subtract(PVector * v1) {
	x -= v1 ->x;
	y -= v1 ->y;
	z -= v1 ->z;
}



PVector PVector::cross(PVector * v1) {
	return PVector(getY()*v1 ->getZ()-getZ()*v1 ->getY(),getZ()*v1->getX()-getX()*v1->getZ(),getX()*v1->getY()-getY()*v1->getX());
}



void PVector::multiply(float scale) {
	x *= scale;
	y *= scale;
	z *= scale;
}

void PVector::set(float x, float y, float z)
{
	this ->x = x;
	this ->y = y;
	this ->z = z;
}

float PVector::angleSubtended(AXIS plane, PVector *pv)
{
	PVector projectV1 = *this;
	PVector projectV2 = *pv;

	switch(plane) {
	case AXIS_X: projectV1.x = 0.0f; projectV2.x = 0.0f; break;
	case AXIS_Y: projectV1.y = 0.0f; projectV2.y = 0.0f; break;
	case AXIS_Z: projectV1.z = 0.0f; projectV2.z = 0.0f; break;
	}

	float angle = projectV1.dotProduct(& projectV2) / (projectV1.getMag() * projectV2.getMag());
	return (float) acos(angle);
}

void PVector::Translate(float dx, float dy, float dz)
{
	x += dx;
	y += dy;
	z += dz;
}

void PVector::Scale(float xScale, float yScale, float zScale)
{
	x *= xScale;
	y *= yScale;
	z *= zScale;
}

void PVector::Rotate(AXIS axis, float theta)
{
	float oldx, oldy, oldz;

	oldx = x;
	oldy = y;
	oldz = z;

	theta = (float) RADIAN(theta);
	switch(axis) {
	case AXIS_X:
		y = (float) (oldy * cos(theta) + oldz * sin(theta));
		z = (float) (oldy * - sin(theta) + oldz * cos(theta));
		break;
	case AXIS_Y:
		x = (float) (oldx * cos(theta) - oldz * sin(theta));
		z = (float) (oldx * sin(theta) + oldz * cos(theta));
		break;
	case AXIS_Z:
		x = (float) (oldx * cos(theta) + oldy * sin(theta));
		y = (float) (oldx * -sin(theta) + oldy * cos(theta));
		break;
	}
}

float PVector::AngleTo(PVector * pTarget)
{
	float fAngle = angleSubtended(AXIS_Z, pTarget);
	
	/*PVector vRightNormal(x,y,z);
	vRightNormal.Rotate(AXIS_Z, 90);
	PVector vLeftNormal(x,y,z);
	vLeftNormal.Rotate(AXIS_Z, -90);

	if(vRightNormal.angleSubtended(AXIS_Z, pTarget) < vLeftNormal.angleSubtended(AXIS_Z, pTarget)) {
		return fAngle;
	} else {
		return 2 * M_PI - fAngle;
	}*/
	PVector vLeftNormal(x,y,z);
	vLeftNormal.Rotate(AXIS_Z, 90);
	if(vLeftNormal.dotProduct(pTarget) < 0) {
		return 2 * M_PI - fAngle;
	} else {
		return fAngle;
	}
}

bool PVector::IsZero()
{
	return x == 0.0f && y == 0.0f && z == 0.0f;
}
