// pbattle.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "PGame.h"
#include "bitmap.h"
#include "gltext.h"

#define NUM_TEX 100

GLuint * textures;
PGame * g;
HWND hWnd;
HDC hDc;
GLuint fontID[MAX_FONTS];
int fontHeights[MAX_FONTS];
int iWindowHeight, iWindowWidth;
bool bFullScreen = false;

void LoadTextures()
{
	int i=0;
	
	textures = initTexArray(NUM_TEX);

	while(i<NUM_TEX) {
		switch(i) {
			case 0: LoadTexture(textures ,"logo.bmp",i); break;
			case 1: LoadTexture(textures ,"new.bmp",i); break;
			case 2: LoadTexture(textures ,"options.bmp",i); break;
			case 3: LoadTexture(textures ,"pikachu.bmp",i); break;
			case 4: LoadTexture(textures ,"charmander.bmp",i); break;
			case 5: LoadTexture(textures ,"squirtle.bmp",i); break;
			case 6: LoadTexture(textures ,"options2.bmp",i); break;
			case 7: LoadTexture(textures ,"pickchar.bmp",i); break;
			case 8: LoadTexture(textures ,"back.bmp",i); break;
			case 9:	LoadTexture(textures ,"difficulty.bmp",i); break;
			case 10: LoadTexture(textures ,"enemies.bmp",i); break;
			case 11: LoadTexture(textures ,"sound.bmp",i); break;
			case 12: LoadTexture(textures ,"easy.bmp",i); break;
			case 13: LoadTexture(textures ,"medium.bmp",i); break;
			case 14: LoadTexture(textures ,"hard.bmp",i); break;
			case 15: LoadTexture(textures ,"1.bmp",i); break;
			case 16: LoadTexture(textures ,"2.bmp",i); break;
			case 17: LoadTexture(textures ,"3.bmp",i); break;
			case 18: LoadTexture(textures ,"on.bmp",i); break;
			case 19: LoadTexture(textures ,"off.bmp",i); break;
			case 20: LoadTexture(textures ,"grass.bmp",i); break;
			case 21: LoadTexture(textures, "message.bmp", i); break;
			case 22: LoadTexture(textures, "clouds.bmp", i); break;
			case 23: LoadTexture(textures, "pikachuicon.bmp", i); break;
			case 24: LoadTexture(textures, "charmandericon.bmp", i); break;
			case 25: LoadTexture(textures, "squirtleicon.bmp", i); break;
			case 26: LoadTexture(textures, "fire.bmp",i); break;
			case 27: LoadTexture(textures, "water.bmp",i); break;
			case 28: LoadTexture(textures, "stone.bmp",i); break;
			case 29: LoadTexture(textures, "grass2.bmp",i); break;
			case 30: LoadTexture(textures, "snow.bmp",i); break;
			case 31: LoadTexture(textures, "continue.bmp", i); break;
			case 32: /*LoadTexture(textures, "Particle.bmp", i);*/ break;
			case 33: LoadTexture(textures, "grass3.bmp",i); break;
			case 34: LoadTexture(textures, "grass4.bmp",i); break;
			case 35: LoadTexture(textures, "grass5.bmp",i); break;
			case 36: LoadTexture(textures, "grass6.bmp",i); break;
			case 37: LoadTexture(textures, "grass7.bmp",i); break;
			case 38: LoadTexture(textures, "grass8.bmp",i); break;
			case 39: LoadTexture(textures, "snow1.bmp",i); break;
			case 40: LoadTexture(textures, "snow2.bmp",i); break;
			case 41: LoadTexture(textures, "snow3.bmp",i); break;
			case 42: LoadTexture(textures, "snow4.bmp",i); break;
			case 43: LoadTexture(textures, "water3.bmp",i); break;
			case 44: LoadTexture(textures, "flare1.bmp", i); break;
			case 45: LoadTexture(textures, "flare2.bmp", i); break;
			case 46: LoadTexture(textures, "icewall.bmp",i); break;
			case 47: LoadTexture(textures, "darkclouds.bmp",i); break;
			case 48: LoadTexture(textures, "fireground.bmp",i); break;
			case 49: LoadTexture(textures, "lava.bmp",i); break;
			case 50: LoadTexture(textures, "firesky.bmp",i); break;
			case 51: LoadTexture(textures, "fireground1.bmp",i); break;
			case 52: LoadTexture(textures, "fireground2.bmp",i); break;
			case 53: LoadTexture(textures, "fireground3.bmp",i); break;
			case 54: LoadTexture(textures, "fireground4.bmp",i); break;
			case 55: LoadTexture(textures, "rainsky.bmp",i); break;
			case 56: LoadTexture(textures, "water2.bmp",i); break;
			case 57: LoadTexture(textures, "grasswater.bmp",i); break;
			case 58: LoadTexture(textures, "grasswater1.bmp",i); break;
			case 59: LoadTexture(textures, "grasswater2.bmp",i); break;
			case 60: LoadTexture(textures, "grasswater3.bmp",i); break;
			case 61: LoadTexture(textures, "grasswater4.bmp",i); break;
			default: break;
		}
		i++;
	}
}

void LoadFonts() {
	for(int i=0; i<MAX_FONTS; i++)  {
		fontID[i] = 0;
		fontHeights[i] = 0;
	}

	CreateOpenGLFont("Arial", 14, 14, FW_BOLD, true);
	CreateOpenGLFont("Verdana", 10, 0, FW_BOLD, false);
	CreateOpenGLFont("Verdana", 30, 0, FW_BOLD, true);
	CreateOpenGLFont("Verdana", 30, 0, FW_BOLD, false);
	CreateOpenGLFont("Arial", 18, 12, FW_BOLD, false);
}

void init(void) {
	LoadTextures();
	LoadFonts();
}

void display(void)
{
	g ->Draw();
}

void keyboard(unsigned char key, int x, int y)
{
	if(key == '`') {
		if(bFullScreen) {
			glutReshapeWindow(600, 480);
			glutPositionWindow(100, 100);
		} else {
			glutFullScreen();
		}
		bFullScreen = !bFullScreen;
	} else {
		g ->Keyboard(key, x, y);
	}
}

void keyboardup(unsigned char key, int x, int y)
{
	g ->KeyboardUp(key, x, y);
}

void reshape(int w, int h)
{
	glViewport(0, 0, (GLsizei) w, (GLsizei) h);
	iWindowWidth = w; iWindowHeight = h;
	g ->ResizeWindow(w, h);
	glMatrixMode(GL_MODELVIEW);
}	

void redraw(void)
{
	glutPostRedisplay();
}

int main(int argc, char* argv[])
{
	srand(time(NULL));

	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
	glutInitWindowSize(600, 480);
	glutInitWindowPosition(100, 100);
	glutCreateWindow("Pokemon Battle Ground!");
	
	hWnd = FindWindow(NULL,"Pokemon Battle Ground!");
	hDc = GetDC(hWnd);
	
	init();
	g = new PGame();
	glutDisplayFunc(display);
	glutReshapeFunc(reshape);
	glutKeyboardFunc(keyboard);
	glutKeyboardUpFunc(keyboardup);
	glutIdleFunc(redraw);
	glutMainLoop();

	return 0;
}


