// gltext.cpp: implementation of the gltext class
// This code was adapted from the digiben tutorial for rendering fonts
// http://www.gametutorials.com/Tutorials/Advanced/OpenGL_Pg3.htm
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "gltext.h"

#define MAX_CHARS 256

void CreateOpenGLFont(char * strFontName, int height, int width, int weight, bool italic)
{
	for(int i=0; i<MAX_FONTS; i++) {
		if(fontID[i]==0) break;
	} 
	if(i >= MAX_FONTS) return;

	HFONT	hFont;										// This will store the handle to our font

	fontID[i] = glGenLists(MAX_CHARS);				// Generate the list for the font
	fontHeights[i] = height;

	hFont = CreateFont(	height,							// Our desired HEIGHT of the font
						width,							// The WIDTH (If we leave this zero it will pick the best width depending on the height)
						0,								// The angle of escapement
						0,								// The angle of orientation
						weight,						// The font's weight (We want it bold)
						italic,							// Italic - We don't want italic
						FALSE,							// Underline - We don't want it underlined
						FALSE,							// Strikeout - We don't want it strikethrough
						ANSI_CHARSET,					// This is the type of character set
						OUT_TT_PRECIS,					// The Output Precision
						CLIP_DEFAULT_PRECIS,			// The Clipping Precision
						ANTIALIASED_QUALITY,			// The quality of the font - We want anitaliased fonts
						FF_DONTCARE|DEFAULT_PITCH,		// The family and pitch of the font.  We don't care.
						strFontName);					// The font name (Like "Arial", "Courier", etc...)

	//hOldFont = (HFONT)SelectObject(ghDC, hFont);

	SelectObject(hDc, hFont);

	wglUseFontBitmaps(hDc, 0, MAX_CHARS - 1, fontID[i]);	// Builds 255 bitmap characters
}


void PositionText(float x, float y, FONT font) {
	glPushAttrib( GL_TRANSFORM_BIT | GL_VIEWPORT_BIT );

	glMatrixMode( GL_PROJECTION );						// Set our matrix to our projection matrix
	glPushMatrix();										// Push on a new matrix to work with
	glLoadIdentity();									// reset the matrix
	glMatrixMode( GL_MODELVIEW );						// Set our matrix to our model view matrix
	glPushMatrix();										// Push on a new matrix to work with
	glLoadIdentity();									// Reset that matrix


	y = iWindowHeight - fontHeights[font] * (float) iWindowHeight / iWindowWidth  - y;				// Calculate the weird screen position


	glViewport( x - 1, y - 1, 0, 0 );					// Create a new viewport to draw into


	glRasterPos4f( 0, 0, 0, 1 );						// Set the drawing position

	glPopMatrix();										// Pop the current modelview matrix off the stack
	glMatrixMode( GL_PROJECTION );						// Go back into projection mode
	glPopMatrix();										// Pop the projection matrix off the stack

	glPopAttrib();
}

void glDrawText(float x, float y, const char *strString, FONT font)
{
	if (strString == NULL)								// Check if a string was given
		return;											// Don't render anything then

	PositionText(x, y, font);									// Call our own function to position the text on screen

	// Now, before we set the list base, we need to save off the current one.
	glPushAttrib(GL_LIST_BIT);							// This saves the list base information

	// Then we want to set the list base to the font's list base, which should be 1 in our case.
	// That way when we call our display list it will start from the font's lists'.
	glListBase(fontID[font]);							// This sets the lists base

	// Now comes the actually rendering.  We pass in the length of the string,
	// then the data types (which are characters so its a UINT), then the actually char array.
	// This will then take the ASCII value of each character and associate it with a bitmap.
	glCallLists(strlen(strString), GL_UNSIGNED_BYTE, strString);

	glPopAttrib();	
}
