#ifndef _DEFINES_H
#define _DEFINES_H

// Constant definitions

#define M_PI 3.14159265358979323846f
#define RADIAN(x) ((x) * M_PI / 180.0f)
#define DEGREE(x) ((x) * 180.f / M_PI)
#define ABS(x) ((float) (x) < 0.0f ? -(x) : (x))
#define MAX_FONTS 10
#define NUM_MOVES 9

typedef enum AXIS {
	AXIS_X,
	AXIS_Y,
	AXIS_Z
} AXIS;

typedef enum DIM {
	D_WIDTH,
	D_LENGTH,
	D_HEIGHT
} DIM;

// Object types
typedef enum OBJECT_TYPE {
	OBJ_TYPE_UNKNOWN,
	OBJ_TYPE_MOVABLE,
	OBJ_TYPE_POKEMON,
	OBJ_TYPE_PROJECTILE,
	OBJ_TYPE_WORLD,
	OBJ_TYPE_ENVIRONMENT
} OBJECT_TYPE;

typedef enum ATTACK_CODE {
	AC_NORMAL_ATTACK,
	AC_CLOSE_ATTACK
} ATTACK_CODE;

typedef enum MOVE_CODE {
	MC_MOVE_FORWARD,
	MC_MOVE_BACK,
	MC_ROTATE_LEFT,
	MC_ROTATE_RIGHT,
	MC_MOVE_LEFT,
	MC_MOVE_RIGHT,
	MC_MOVE_BLOCK,
	MC_MOVE_FLIP,
	MC_MOVE_AI,
	MC_MOVE_UP,
	MC_MOVE_DOWN,
	MC_MOVE_FLOAT,
	MC_MOVE_SURROUND,
	MC_MOVE_FALL,
	MC_MOVE_NOTHING,
	MC_MOVE_RAIN
} MOVE_CODE;

typedef enum ENERGY_TYPE {
	ET_LIFE,
	ET_CURRENT_LIFE,
	ET_ATTACK,
	ET_SPEED
} ENERGY_TYPE;

typedef enum GAME_STATE {
	GS_START_MENU,
	GS_CHARACTER_MENU,
	GS_OPTIONS_MENU,
	GS_GAME,
	GS_GAME_COUNTDOWN,
	GS_GAME_VICTORY,
	GS_GAME_EXPERIENCE
} GAME_STATE;

typedef enum GAME_OPTION {
	GO_CHARACTER,
	GO_DIFFICULTY,
	GO_NUM_ENEMIES,
	GO_SOUND
} GAME_OPTION;

typedef enum DAMAGE_TYPE {
	DT_NORMAL,
	DT_LIGHTNING,
	DT_FIRE,
	DT_WATER
} DAMAGE_TYPE;

typedef enum SOUND_TYPE {
	SOUND_PIK,
	SOUND_THU,
	SOUND_CHAR,
	SOUND_FIRE,
	SOUND_SQUIRT,
	SOUND_BUBBLE,
	SOUND_STREAM,
	SOUND_LAVA,
	SOUND_WAVE,
	SOUND_RAIN,
	SOUND_WIND
} SOUND_TYPE;

typedef enum FONT {
	FONT_POKEMON_NAME,
	FONT_POKEMON_LEVEL,
	FONT_COUNTDOWN,
	FONT_GAME_RESULT,
	FONT_EXPERIENCE
} FONT;

typedef enum AI_GOAL {
	AI_ATTACK,
	AI_DEFEND,
	AI_WAIT
} AI_GOAL;

typedef enum AI_MOVE {
	AI_MOVE_FORWARD,
	AI_MOVE_BACK,
	AI_ROTATE_LEFT,
	AI_ROTATE_RIGHT,
	AI_FORWARD_LEFT,
	AI_FORWARD_RIGHT,
	AI_BACK_LEFT,
	AI_BACK_RIGHT,
	AI_MOVE_LEFT,
	AI_MOVE_RIGHT,
	AI_MOVE_FLIP,
	AI_MOVE_ATTACK,
	AI_MOVE_BLOCK,
	AI_MOVE_NOTHING
} AI_MOVES;

typedef enum POKEMON_STAT {
	PS_POKEMON,
	PS_LEVEL,
	PS_EXPERIENCE,
	PS_NEXTLEVEL,
	PS_HP,
	PS_ATTACK,
	PS_SPEED
} POKEMON_STAT;

typedef enum POKEMON_TYPE {
	PT_PIKACHU,
	PT_CHARMANDER,
	PT_SQUIRTLE
} POKEMON_TYPE;
#endif