/* bitmap.cpp-source file for bitmap.h */

#include "stdafx.h"
#include "bitmap.h"

/* initializes the texture array to be numtexs long */

GLuint *initTexArray(int numtexs) {
	GLuint *textures;

	textures=(GLuint *)malloc(numtexs*sizeof(GLuint));
	return textures;
}

/* loads a .bmp image and returns it as a value */

AUX_RGBImageRec *LoadBMP(char *Filename) {
	FILE *File=NULL;	

	if (Filename==NULL) return NULL;	

	File=fopen(Filename,"r");

	if (File!=NULL) {
		fclose(File);
		return auxDIBImageLoad(Filename);	
	}
	return NULL;
}

/* loads the .bmp file as a texture and stores it in the texture array */

void LoadTexture(GLuint *textures, char *file, int texnum) {
	AUX_RGBImageRec *tex;

	tex=NULL;

	if ((tex=LoadBMP(file))!=NULL) {
		glGenTextures(1, &textures[texnum]);

		glBindTexture(GL_TEXTURE_2D, textures[texnum]);
	
		glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB8, tex->sizeX, tex->sizeY, 0, GL_RGB, GL_UNSIGNED_BYTE, tex->data);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR_MIPMAP_NEAREST);
		gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB8, tex->sizeX, tex->sizeY, GL_RGB, GL_UNSIGNED_BYTE, tex->data); 
		free(tex->data);
		free(tex);
	}
}
