// PWaterAttackParticle.cpp: implementation of the PWaterAttackParticle class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PWaterAttackParticle.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

PWaterAttackParticle::PWaterAttackParticle(PGame * pGame, PDrawableObject * pSource, int iNum):
	PParticle(pGame, pSource)
{
	this ->iNum = iNum;

	fColor = (10 - iNum) * 0.1f;
	fColor *= fColor * fColor;
	pVolume.SetDimensions(0.0f, 0.0f, 0.0f);
}

PWaterAttackParticle::~PWaterAttackParticle()
{

}

/* draws a water attack particle */

void PWaterAttackParticle::Draw()
{
	glDisable(GL_LIGHTING);

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);
	glEnable(GL_TEXTURE_2D);

	glBindTexture(GL_TEXTURE_2D, textures[44]); 

	glColor3f(fColor, fColor, 1.0f);  

	glBegin(GL_QUADS);
		glTexCoord2f(0,0);
		glVertex3f(0, -0.25f, -0.25f);
			
		glTexCoord2f(1,0);
		glVertex3f(0, 0.25f, - 0.25f);
			
		glTexCoord2f(1,1);
		glVertex3f(0, 0.25f, 0.25f);
			
		glTexCoord2f(0,1);
		glVertex3f(0, -0.25f, 0.25f);	
	glEnd(); 

	glDisable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);
}


