// PWaterAttack.cpp: implementation of the PWaterAttack class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PWaterAttack.h"
#include "../PPokemon.h"
#include "PWaterAttackParticle.h"
#include "../PSplashParticle.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

PWaterAttack::PWaterAttack(PGame *pGame, PDrawableObject *pSource):
	PProjectile(pSource)
{
	this ->pGame = pGame;
	this->pSource=pSource;

	width = 0.75f;
	length = 0.75f;
	height = 0.75f;

	fDistance = 0.0f;
	fVelocity = 10.0f;
	loc.x=pSource->GetCoordinate(AXIS_X);
	loc.y=pSource->GetCoordinate(AXIS_Y);
	loc.z=pSource->GetCoordinate(AXIS_Z);
	pVolume.SetDimensions(width, length, height);
	if(pGame->GetGameOption(GO_SOUND)==1) {
		PSound *pSound=pGame->GetSoundObject();
		pSound->PlaySound(SOUND_WAVE, false,this->Distance(pGame->GetFocusObject()));
	}
}

PWaterAttack::~PWaterAttack()
{

}

void PWaterAttack::Draw()
{

}

/* moves the water projectile forward */

void PWaterAttack::Move(MOVE_CODE mcMove)
{
	PProjectile::Move(mcMove);
	if(loc.z+0.1f<pGame->ground->GetHeight(loc.x,loc.y)) HandleCollision(0);
	else {
		fDistance += fVelocity * pGame ->GetTimeElapsed();
		if(fDistance > 10.0f) {
			CleanupParticles();
			pGame ->RemoveObject(this);
		}
	}
}

/* handles a collision between the pokemon and a water attack or between the ground and the water attack */

void PWaterAttack::HandleCollision(PDrawableObject *pObjectCollidedWith)
{
	if(pObjectCollidedWith && pObjectCollidedWith ->GetObjectType() == OBJ_TYPE_POKEMON) {
		PPokemon * pTarget = (PPokemon *) pObjectCollidedWith;
		if(pTarget!=pSource && !pTarget ->IsBlocking()) {
			PVector tVector;
			int iDamage;
			float x,y,z;
			x=loc.x+pDirection.getX();
			y=loc.y+pDirection.getY();

			/*if(x>=(float)pGame->ground->GetXWidth()-1) x=(float)pGame->ground->GetXWidth()-1;
			if(x<=0) x=0;
			if(y>=(float)pGame->ground->GetYLength()-1) y=(float)(float)pGame->ground->GetYLength()-1;
			if(y<=0) y=0;*/

			if(x>=(float)pGame->ground->GetXWidth()-1) x=(float)pGame->ground->GetXWidth()-1;
			if(x<=0) x=0;
			if(y>=(float)pGame->ground->GetYLength()-1) y=(float)(float)pGame->ground->GetYLength()-1;
			if(y<=0) y=0;

			z=pGame->ground->GetHeight(x,y);

			tVector=PVector(x,y,z);

			CPtrArray aCollidingObjects;

			pGame ->DetectCollisions(pTarget, pTarget->GetBoundVolume(), & aCollidingObjects);

			PDrawableObject * pCollidingObject;
			for(int i=0; i<aCollidingObjects.GetSize(); i++) {
				pCollidingObject=(PDrawableObject *) aCollidingObjects.GetAt(i);
				if(pCollidingObject->GetObjectType()==OBJ_TYPE_POKEMON && pCollidingObject!=pTarget) return;
			}

			if(pSource ->GetObjectType() == OBJ_TYPE_POKEMON) {
				 int iAttack = ((PPokemon *) pSource) ->GetStat(PS_ATTACK) * 0.25f;
				 iDamage = iAttack + rand() % iAttack;
			} else {
				iDamage = 10;
			}

			pTarget->SetCoordinates(tVector.getX(),tVector.getY(),tVector.getZ());
			pTarget ->TakeDamage(DT_WATER, iDamage);
		}
	}
	CleanupParticles();
	pGame ->RemoveObject(this);

	PSplashParticle * pSplash;
	PVector dir;
	//float rotation;
	for(int i=0; i<6; i++) {
		pSplash = new PSplashParticle(pGame, this);
		pSplash ->SetCoordinates(loc.x, loc.y, loc.z + 0.5f);
		dir = pDirection2D;
		dir.invert();
		dir.multiply(0.2f);
		if(i < 3) {
			dir.Rotate(AXIS_Z, 45 + rand() % 45);
		} else {
			dir.Rotate(AXIS_Z, -(45 + rand() % 45));
		}

		dir.z = 0.5f + rand() % 10 * 0.1f;
		pSplash ->SetDirection(&dir);
		pGame ->AddObject(pSplash);
	}
}

/* makes water particles */

void PWaterAttack::MakeWaterParticles()
{
	PWaterAttackParticle * pWater;

	for(int i=0; i<10; i++) {
		pWater = new PWaterAttackParticle(pGame, this, i);
		pWater ->SetCoordinates(loc.x - 0.2f * i * pDirection.x, 
								loc.y - 0.2f * i * pDirection.y, 
								loc.z);
		pWater ->SetDirection(& pDirection);
		pWater ->SetVelocity(fVelocity);
		aParticles.Add(pWater);
		pGame ->AddObject(pWater);
	}
}

/* removes the particles from the game */

void PWaterAttack::CleanupParticles()
{
	for(int i=aParticles.GetSize() - 1; i>=0; i--) {
		pGame ->RemoveObject( (PDrawableObject *) aParticles.GetAt(i));
	}
}
